/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.query.Optimizer;
import unity.query.SubQuery;
import unity.util.StringFunc;

public class SubqueryValue
extends Expression {
    private static final long serialVersionUID = 1L;
    private Operator op;
    private Object val;
    private boolean valueRetrieved = false;
    private SubQuery sq;
    private int number;
    private boolean correlated;
    private Tuple tuple;

    public SubqueryValue(Operator operator, SubQuery subQuery) {
        this.op = operator;
        this.sq = subQuery;
        this.val = null;
        this.correlated = subQuery.isCorrelated();
        this.number = Integer.MAX_VALUE;
        this.tuple = new Tuple();
    }

    private Object getValue(Tuple tuple) throws SQLException {
        this.val = null;
        this.op.init();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.op.next(this.tuple) && arrayList.size() < this.number) {
            arrayList.add(this.tuple.getObject(0));
        }
        this.val = arrayList.size() == 0 ? null : (arrayList.size() == 1 ? arrayList.get(0) : arrayList);
        return this.val;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        if (!this.correlated) {
            if (!this.valueRetrieved) {
                this.getValue(tuple);
                this.valueRetrieved = true;
            }
            return this.val;
        }
        this.sq.setParentTuple(tuple);
        this.getValue(tuple);
        return this.val;
    }

    public Object evaluateOne(Tuple tuple) throws SQLException {
        if (this.valueRetrieved) {
            return this.val;
        }
        this.valueRetrieved = true;
        this.val = null;
        Tuple tuple2 = new Tuple();
        this.op.init();
        this.val = this.op.next(tuple2);
        return this.val;
    }

    public String toString() {
        if (this.op == null) {
            return "";
        }
        return '(' + StringFunc.oneLineSQL(Optimizer.buildSQL(this.op.getQueryNode())) + ')';
    }

    public void setNumber(int n) {
        this.number = n;
    }
}

