/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;

public class F_Month
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression dateExpr;

    public F_Month(Expression expression) {
        this.dateExpr = expression;
        this.returnType = this.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.dateExpr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof java.sql.Date || object instanceof Date) {
            Date date = (Date)object;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return gregorianCalendar.get(2) + 1;
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 4;
    }

    public static int[] getParamListTypes() {
        return new int[]{91};
    }

    public static String getFunctionName() {
        return "MONTH";
    }

    @Override
    public String toString(Relation relation) {
        return "MONTH(" + this.dateExpr.toString(relation) + ")";
    }
}

