/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.SQLValidatorPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import net.sourceforge.squirrel_sql.plugins.sqlval.cmd.DisconnectCommand;

public class DisconnectAction
extends SquirrelAction
implements ISessionAction {
    private static final ILogger s_log = LoggerController.createLogger(DisconnectAction.class);
    private final WebServicePreferences _prefs;
    private final SQLValidatorPlugin _plugin;
    private ISession _session;

    public DisconnectAction(IApplication app, IResources resources, WebServicePreferences prefs, SQLValidatorPlugin plugin) {
        super(app, resources);
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        this._prefs = prefs;
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            WebServiceSessionProperties wss = this._plugin.getWebServiceSessionProperties(this._session);
            try {
                new DisconnectCommand(this._session, this._prefs, wss).execute();
            }
            catch (BaseException ex) {
                this._session.getApplication().showErrorDialog("Error closing SQL Validation web service", (Throwable)ex);
            }
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }
}

