/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.LogonDialog;
import net.sourceforge.squirrel_sql.plugins.sqlval.SQLValidatorPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;

public class ConnectAction
extends SquirrelAction
implements ISessionAction {
    private static final ILogger s_log = LoggerController.createLogger(ConnectAction.class);
    private final WebServicePreferences _prefs;
    private final SQLValidatorPlugin _plugin;
    private ISession _session;

    public ConnectAction(IApplication app, IResources resources, WebServicePreferences prefs, SQLValidatorPlugin plugin) {
        super(app, resources);
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        this._prefs = prefs;
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            WebServiceSessionProperties sessionProps = this._plugin.getWebServiceSessionProperties(this._session);
            LogonDialog dlog = new LogonDialog(this._session, this._prefs, sessionProps);
            dlog.setVisible(true);
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }
}

