/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.gui;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.AbstractPostgresDialog;

public class VacuumTableDialog
extends AbstractPostgresDialog {
    protected ITableInfo[] _infos;
    protected JCheckBox _fullCheckBox;
    protected JCheckBox _analyzeCheckBox;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(VacuumTableDialog.class);

    public VacuumTableDialog(ITableInfo[] infos) {
        this._infos = infos;
        this.setTitle(i18n.TITLE);
        this.init();
    }

    public VacuumTableDialog() {
        this._infos = null;
        this.setTitle(i18n.TITLE);
        this.init();
    }

    protected void init() {
        this.defaultInit();
        JLabel catalogLabel = this.getBorderedLabel(i18n.CATALOG_LABEL + " ", this._emptyBorder);
        this._panel.add((Component)catalogLabel, this.getLabelConstraints(this._gbc));
        JTextField catalogTextField = this.getSizedTextField(this._mediumField);
        catalogTextField.setEditable(false);
        if (this._infos != null) {
            catalogTextField.setText(this._infos[0].getCatalogName());
        }
        this._panel.add((Component)catalogTextField, this.getFieldConstraints(this._gbc));
        JLabel schemaLabel = this.getBorderedLabel(i18n.SCHEMA_LABEL + " ", this._emptyBorder);
        this._panel.add((Component)schemaLabel, this.getLabelConstraints(this._gbc));
        JTextField schemaTextField = this.getSizedTextField(this._mediumField);
        schemaTextField.setEditable(false);
        if (this._infos != null) {
            schemaTextField.setText(this._infos[0].getSchemaName());
        }
        this._panel.add((Component)schemaTextField, this.getFieldConstraints(this._gbc));
        JLabel tableLabel = this.getBorderedLabel(i18n.TABLE_LABEL + " ", this._emptyBorder);
        tableLabel.setVerticalAlignment(1);
        this._panel.add((Component)tableLabel, this.getLabelConstraints(this._gbc));
        JList<Object> tableList = this._infos != null ? new JList<String>(this.getSimpleNames(this._infos)) : new JList();
        tableList.setEnabled(false);
        JScrollPane tableScrollPane = new JScrollPane(tableList);
        this._gbc = this.getFieldConstraints(this._gbc);
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._panel.add((Component)tableScrollPane, this._gbc);
        JLabel fullLabel = new JLabel(i18n.FULL_LABEL);
        fullLabel.setBorder(this._emptyBorder);
        this._panel.add((Component)fullLabel, this.getLabelConstraints(this._gbc));
        this._fullCheckBox = new JCheckBox();
        this._fullCheckBox.setToolTipText(i18n.FULL_TOOLTIP);
        this._fullCheckBox.setPreferredSize(this._mediumField);
        this._panel.add((Component)this._fullCheckBox, this.getFieldConstraints(this._gbc));
        JLabel analyzeLabel = new JLabel(i18n.ANALYZE_LABEL);
        analyzeLabel.setBorder(this._emptyBorder);
        this._panel.add((Component)analyzeLabel, this.getLabelConstraints(this._gbc));
        this._analyzeCheckBox = new JCheckBox();
        this._analyzeCheckBox.setToolTipText(i18n.ANALYZE_TOOLTIP);
        this._analyzeCheckBox.setPreferredSize(this._mediumField);
        this._panel.add((Component)this._analyzeCheckBox, this.getFieldConstraints(this._gbc));
    }

    private String[] getSimpleNames(ITableInfo[] infos) {
        String[] result = new String[infos.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = infos[i].getSimpleName();
        }
        return result;
    }

    public void setContent(ITableInfo[] infos) {
        this._infos = infos;
    }

    public ITableInfo[] getContent() {
        return this._infos;
    }

    public boolean getFullOption() {
        return this._fullCheckBox.isSelected();
    }

    public boolean getAnalyzeOption() {
        return this._analyzeCheckBox.isSelected();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String TITLE = VacuumTableDialog.access$000().getString("VacuumTableDialog.title");
        public static final String CATALOG_LABEL = VacuumTableDialog.access$000().getString("VacuumTableDialog.catalogLabel");
        public static final String SCHEMA_LABEL = VacuumTableDialog.access$000().getString("VacuumTableDialog.schemaLabel");
        public static final String TABLE_LABEL = VacuumTableDialog.access$000().getString("VacuumTableDialog.tableLabel");
        public static final String FULL_LABEL = VacuumTableDialog.access$000().getString("VacuumTableDialog.fullLabel");
        public static final String FULL_TOOLTIP = VacuumTableDialog.access$000().getString("VacuumTableDialog.fullTooltip");
        public static final String ANALYZE_LABEL = VacuumTableDialog.access$000().getString("VacuumTableDialog.analyzeLabel");
        public static final String ANALYZE_TOOLTIP = VacuumTableDialog.access$000().getString("VacuumTableDialog.analyzeTooltip");
    }
}

