/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.explain;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.PostgresPlugin;
import net.sourceforge.squirrel_sql.plugins.postgres.explain.ExplainExecuterPanel;

public class ExplainTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExplainTab.class);
    private final ISession _session;
    private final ExplainExecuterPanel _parent;
    private SQLExecutionInfo _info;
    private ResultSetDataSet _rsds;
    private IDataSetUpdateableTableModel _model;
    private String _query;
    private final JScrollPane _resultSetSp = new JScrollPane();
    private boolean _allowsEditing;

    public ExplainTab(ISession session, ExplainExecuterPanel parent, ResultSetDataSet rsds, SQLExecutionInfo info, IDataSetUpdateableTableModel model) {
        this._session = session;
        this._parent = parent;
        this._rsds = rsds;
        this._info = info;
        this._model = model;
        this.init();
        this.createGUI();
    }

    private void init() {
        this._query = this._info.getSQL().substring("EXPLAIN ANALYZE ".length());
        this._model.addListener(new DataSetUpdateableTableModelListener(){

            public void forceEditMode(boolean mode) {
                ExplainTab.this.onForceEditMode(mode);
            }
        });
        this._allowsEditing = new EditableSqlCheck(this._info).allowsEditing();
        if (this._allowsEditing) {
            this.setResultSetMode(this._session.getProperties().getSQLResultsOutputClassName());
        } else {
            this.setResultSetMode(this._session.getProperties().getReadOnlySQLResultsOutputClassName());
        }
    }

    public void reInit(ResultSetDataSet rsds, SQLExecutionInfo info, IDataSetUpdateableTableModel model) {
        this._rsds = rsds;
        this._info = info;
        this._model = model;
        final JScrollPane old_resultSetSp = this._resultSetSp;
        this.init();
        this._resultSetSp.setBorder(BorderFactory.createEmptyBorder());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplainTab.this.remove(old_resultSetSp);
                ExplainTab.this.add((Component)ExplainTab.this._resultSetSp, "Center");
            }
        });
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 0, 0));
        buttonPanel.add(new TabButton((Action)((Object)new RerunAction())));
        buttonPanel.add(new TabButton((Action)((Object)new CloseAction())));
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BorderLayout());
        headerPanel.add((Component)buttonPanel, "East");
        headerPanel.add((Component)new JLabel(this._query), "Center");
        this.add((Component)headerPanel, "North");
        this._resultSetSp.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this._resultSetSp, "Center");
    }

    public String getTitle() {
        if (this._query.length() > 20) {
            return this._query.substring(0, 20);
        }
        return this._query;
    }

    public String getToolTip() {
        return this._query;
    }

    public String getQuery() {
        return this._query;
    }

    private void onForceEditMode(boolean editable) {
        if (editable && !this._allowsEditing) {
            JOptionPane.showMessageDialog((Component)this._session.getApplication().getMainFrame(), i18n.CAN_NOT_EDIT);
            return;
        }
        if (editable) {
            this.setResultSetMode(SessionProperties.IDataSetDestinations.EDITABLE_TABLE);
        } else {
            this.setResultSetMode(this._session.getProperties().getReadOnlySQLResultsOutputClassName());
        }
    }

    private void setResultSetMode(final String outputClassName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IDataSetViewer resultSetOutput = BaseDataSetViewerDestination.getInstance((String)outputClassName, (IDataSetUpdateableModel)ExplainTab.this._model, (ISession)ExplainTab.this._session);
                ExplainTab.this._resultSetSp.setViewportView(resultSetOutput.getComponent());
                ExplainTab.this._resultSetSp.setRowHeader(null);
                ExplainTab.this._rsds.resetCursor();
                try {
                    resultSetOutput.show((IDataSet)ExplainTab.this._rsds, null);
                }
                catch (DataSetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class MyResources
    extends Resources {
        protected MyResources(String rsrcBundleBaseName, ClassLoader cl) {
            super(rsrcBundleBaseName, cl);
        }
    }

    private class RerunAction
    extends SquirrelAction {
        private static final long serialVersionUID = 1L;

        RerunAction() {
            super(ExplainTab.this._session.getApplication(), (IResources)new MyResources(PostgresPlugin.class.getName(), PostgresPlugin.class.getClassLoader()));
        }

        public void actionPerformed(ActionEvent evt) {
            ExplainTab.this._parent.reRunTab(ExplainTab.this);
        }
    }

    private class CloseAction
    extends SquirrelAction {
        private static final long serialVersionUID = 1L;

        CloseAction() {
            super(ExplainTab.this._session.getApplication(), (IResources)new MyResources(PostgresPlugin.class.getName(), PostgresPlugin.class.getClassLoader()));
        }

        public void actionPerformed(ActionEvent evt) {
            ExplainTab.this._parent.closeTab(ExplainTab.this);
        }
    }

    private final class TabButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public TabButton(Action action) {
            super(action);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setText("");
        }
    }

    static interface i18n {
        public static final String CAN_NOT_EDIT = ExplainTab.access$000().getString("ExplainTab.cannotedit");
    }
}

