/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d.geometry;

import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.j3d.J3DGeo;
import javax.vecmath.Point3d;

public class SphereBox {
    LatLonPoint upper;
    LatLonPoint lower;
    double lowerElevation;
    double upperElevation;

    public SphereBox() {
        this.lowerElevation = Double.POSITIVE_INFINITY;
        this.upperElevation = Double.NEGATIVE_INFINITY;
    }

    public SphereBox(Point3d lower, Point3d upper) {
        this.init(new J3DGeo(lower.x, lower.y, lower.z));
        this.add(upper);
    }

    public SphereBox(J3DGeo lower, J3DGeo upper) {
        this.init(lower);
        this.add(upper);
    }

    public SphereBox(SphereBox sBox) {
        this.upper = sBox.upper;
        this.lower = sBox.lower;
        this.lowerElevation = sBox.lowerElevation;
        this.upperElevation = sBox.upperElevation;
    }

    public void init(J3DGeo lower) {
        this.lower = new LatLonPoint.Double(lower.getLatitudeRadians(), lower.getLongitudeRadians(), true);
        this.upper = new LatLonPoint.Double(lower.getLatitudeRadians(), lower.getLongitudeRadians(), true);
        this.upperElevation = this.lowerElevation = lower.length();
    }

    public J3DGeo getLower() {
        if (this.lower != null) {
            return new J3DGeo(this.lower.getRadLat(), this.lower.getRadLon(), false, this.lowerElevation);
        }
        return null;
    }

    public J3DGeo getUpper() {
        if (this.upper != null) {
            return new J3DGeo(this.upper.getRadLat(), this.upper.getRadLon(), false, this.upperElevation);
        }
        return null;
    }

    public void add(Point3d pt) {
        this.add(new J3DGeo(pt.x, pt.y, pt.z));
    }

    public void add(J3DGeo pt) {
        if (this.lower == null) {
            this.init(pt);
            return;
        }
        double llat = this.lower.getRadLat();
        double llon = this.lower.getRadLon();
        double ulat = this.upper.getRadLat();
        double ulon = this.upper.getRadLon();
        double lat = pt.getLatitudeRadians();
        double lon = pt.getLongitudeRadians();
        double elev = pt.length();
        if (lat < llat) {
            llat = lat;
        }
        if (lat > ulat) {
            ulat = lat;
        }
        if (lon < llon) {
            llon = lon;
        }
        if (lon > ulon) {
            ulon = lon;
        }
        if (elev < this.lowerElevation) {
            this.lowerElevation = elev;
        }
        if (elev > this.upperElevation) {
            this.upperElevation = elev;
        }
        this.upper.setLatLon(ulat, ulon, true);
        this.lower.setLatLon(llat, llon, true);
    }

    public void add(SphereBox sBox) {
        J3DGeo lg = sBox.getLower();
        J3DGeo ug = sBox.getUpper();
        if (lg != null) {
            this.add(lg);
        }
        if (ug != null) {
            this.add(ug);
        }
    }
}

