/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d.geometry;

import com.bbn.openmap.MapHandlerChild;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.j3d.MapContent;
import com.bbn.openmap.tools.j3d.OM3DGraphicHandler;
import com.bbn.openmap.tools.j3d.OMGraphicUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.j3d.Shape3D;

public class Curtain
extends MapHandlerChild
implements OM3DGraphicHandler {
    protected Color color = Color.lightGray;
    Iterator curtains = null;
    protected double extra = 0.0;
    protected double curtainHeight = 500.0;

    public void addGraphicsToScene(MapContent mapContent) {
        if (this.curtains == null) {
            this.curtains = this.init(mapContent.getProjection());
        }
        while (this.curtains.hasNext()) {
            mapContent.add((Shape3D)this.curtains.next());
        }
        this.curtains = null;
    }

    protected Iterator init(Projection proj) {
        HashSet<Shape3D> set = new HashSet<Shape3D>();
        double width = (double)proj.getWidth() + this.extra;
        double depth = (double)proj.getHeight() + this.extra;
        double height = this.curtainHeight + this.extra;
        double origin = 0.0 - this.extra;
        double[] data = new double[]{origin, origin, origin, width, origin, origin, width, depth, origin, origin, depth, origin, width, origin, origin, width, depth, origin, width, depth, height, width, origin, height, width, depth, origin, width, depth, height, origin, depth, height, origin, depth, origin, origin, origin, origin, origin, origin, height, origin, depth, height, origin, depth, origin, origin, origin, height, width, origin, height, width, depth, height, origin, depth, height};
        int[] stripCount = new int[]{4, 4, 4, 4, 4};
        int dataIndex = 0;
        int[] sc = new int[1];
        for (int i = 0; i < stripCount.length; ++i) {
            double[] temp = new double[12];
            sc[0] = stripCount[i];
            System.arraycopy(data, dataIndex, temp, 0, 12);
            set.add(OMGraphicUtil.createFilled(temp, sc, this.color));
            dataIndex += 12;
        }
        return set.iterator();
    }

    public void setColor(Color curtainColor) {
        this.color = curtainColor;
    }

    public Color getColor() {
        return this.color;
    }

    public void setCurtainHeight(double height) {
        this.curtainHeight = height;
    }

    public double getCurtainHeight() {
        return this.curtainHeight;
    }
}

