/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.corba;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;

public class IOR {
    static boolean debug = false;
    static boolean verbose = false;
    byte[] hex;

    IOR(byte[] rawIOR) {
        this.hex = rawIOR;
    }

    void parse(PrintWriter out) {
        DataPointer dp;
        int endian;
        String prefix = new String(this.hex, 0, 4);
        if (!prefix.equals("IOR:")) {
            System.err.println("Invalid IOR");
            System.err.println("The first four bytes should be: 'IOR:'");
            System.err.println("Found: " + prefix);
            System.exit(1);
        }
        int iorLength = (this.hex.length - 4) / 2;
        byte[] ior = new byte[iorLength];
        int hexIndex = 4;
        int iorIndex = 0;
        while (hexIndex < this.hex.length) {
            try {
                ior[iorIndex] = (byte)((this.hexByteToInt(this.hex[hexIndex]) << 4) + this.hexByteToInt(this.hex[hexIndex + 1]));
            }
            catch (NumberFormatException e) {
                System.err.println("Index: " + hexIndex);
                System.err.println(e);
                return;
            }
            hexIndex += 2;
            ++iorIndex;
        }
        if (debug) {
            for (int i = 0; i < iorLength; ++i) {
                System.out.println(i + ": " + ior[i] + ", " + (char)ior[i]);
            }
        }
        if ((endian = this.getLongAt(dp = new DataPointer(debug), ior)) == 0) {
            out.println("Big Endian");
        } else {
            out.println("Little Endian");
        }
        int type_id_length = this.getLongAt(dp, ior);
        if (verbose) {
            out.println("type id length = " + type_id_length);
        }
        String type_id = this.getStringAt(dp, ior, type_id_length);
        out.println("Type ID = \"" + type_id + "\"");
        int nProfiles = this.getLongAt(dp, ior);
        if (nProfiles < 0) {
            System.err.println("Found " + nProfiles + " profiles.  Aborting");
            System.exit(1);
        }
        if (verbose) {
            if (nProfiles == 0) {
                out.println("There are no profiles.");
            } else if (nProfiles == 1) {
                out.println("There is 1 profile.");
            } else {
                out.println("There are " + nProfiles + " profiles.");
            }
        }
        for (int p = 0; p < nProfiles; ++p) {
            int profileDataLength;
            int ProfileID = this.getLongAt(dp, ior);
            out.println("Profile " + p + ": ");
            if (ProfileID == 0) {
                out.println("\tID: TAG_INTERNET_IOP");
                profileDataLength = this.getLongAt(dp, ior);
                if (verbose) {
                    out.println("\tProfile length: " + profileDataLength);
                }
                int major = this.getShortAt(dp, ior);
                int minor = this.getShortAt(dp, ior);
                out.println("\tIIOP Version: " + major + "." + minor);
                int hostLength = this.getLongAt(dp, ior);
                String host = this.getStringAt(dp, ior, hostLength);
                out.println("\tHost: " + host);
                int port = this.getShortAt(dp, ior);
                out.println("\tPort: " + port);
                int objectKeyLength = this.getLongAt(dp, ior);
                if (verbose) {
                    out.println("\tObject Key Length: " + objectKeyLength);
                }
                String objectKey = this.getStringAt(dp, ior, objectKeyLength);
                out.println("\tObject Key: \"" + objectKey + "\"");
                continue;
            }
            if (ProfileID == 1) {
                out.println("\tID: TAG_MULTIPLE_COMPONENTS");
                profileDataLength = this.getLongAt(dp, ior);
                out.println("\tProfile length: " + profileDataLength);
                dp.incPointer(profileDataLength);
                continue;
            }
            out.println("Unknown, value is " + ProfileID);
            return;
        }
        if (dp.getPointer() == iorLength) {
            out.println("IOR read successfully");
        } else if (dp.getPointer() > iorLength) {
            System.err.println("Failure! Overran buffer.");
        } else if (dp.getPointer() < iorLength) {
            System.err.println("Failure! Incomplete read.");
        } else {
            System.err.println("Failure! Unknown state.");
        }
    }

    int hexByteToInt(byte b) {
        char hex = (char)b;
        if ('0' <= hex && hex <= '9') {
            return hex - 48;
        }
        if ('a' <= hex && hex <= 'f') {
            return 10 + (hex - 97);
        }
        if ('A' <= hex && hex <= 'F') {
            return 10 + (hex - 65);
        }
        throw new NumberFormatException("byte: " + b);
    }

    int getInt4At(DataPointer dp, byte[] b) {
        dp.align(4);
        int i = dp.getPointer();
        int x = (b[i] << 24) + (b[i + 1] << 16) + (b[i + 2] << 8) + (b[i + 3] << 0);
        dp.incPointer(4);
        return x;
    }

    int getInt2At(DataPointer dp, byte[] b) {
        dp.align(2);
        int i = dp.getPointer();
        int x = (b[i] << 8) + (b[i + 1] & 0xFF);
        dp.incPointer(2);
        return x;
    }

    int getShortAt(DataPointer dp, byte[] b) {
        return this.getInt2At(dp, b);
    }

    int getLongAt(DataPointer dp, byte[] b) {
        return this.getInt4At(dp, b);
    }

    String getStringAt(DataPointer dp, byte[] b, int length) {
        dp.align(1);
        int end = dp.getPointer() + length - 1;
        StringBuffer buf = new StringBuffer(length);
        for (int j = dp.getPointer(); j < end; ++j) {
            buf.append((char)b[j]);
        }
        dp.incPointer(length);
        return buf.toString();
    }

    public static void printUsage() {
        System.err.println("usage: java ior [-verbose] [-debug] filename");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            IOR.printUsage();
            System.exit(1);
        }
        String filename = null;
        for (int a = 0; a < args.length; ++a) {
            if (args[a].charAt(0) == '-') {
                if (args[a].equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (args[a].equals("-debug")) {
                    debug = true;
                    continue;
                }
                IOR.printUsage();
                System.exit(1);
                continue;
            }
            if (filename == null) {
                filename = args[a];
                continue;
            }
            IOR.printUsage();
            System.exit(1);
        }
        if (verbose || debug) {
            System.out.println("-------------------------------------------");
            System.out.println("verbose = " + verbose);
            System.out.println("debug = " + debug);
            System.out.println("filename = " + filename);
            System.out.println("-------------------------------------------");
            System.out.println();
        }
        byte[] contents = null;
        File f = new File(filename);
        try {
            FileInputStream fis = new FileInputStream(f);
            int nAvail = fis.available();
            contents = new byte[nAvail];
            fis.read(contents);
            fis.close();
            new IOR(contents).parse(new PrintWriter(System.out, true));
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + f);
            return;
        }
        catch (IOException e) {
            System.err.println("Error reading file " + f);
            return;
        }
    }

    class DataPointer {
        int ptr = 0;
        boolean debug;

        DataPointer() {
            this.debug = false;
        }

        DataPointer(boolean dbg) {
            this.debug = dbg;
        }

        void incPointer(int increment) {
            if (this.debug) {
                System.out.print("ptr: " + this.ptr + "+" + increment + " = ");
            }
            this.ptr += increment;
            if (this.debug) {
                System.out.println(this.ptr);
            }
        }

        int getPointer() {
            return this.ptr;
        }

        void align(int boundary) {
            while (this.ptr % boundary != 0) {
                if (this.debug) {
                    System.out.println("ptr: align: " + this.ptr + ", " + boundary);
                }
                ++this.ptr;
            }
        }
    }
}

