/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.CTEntry;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.DeclutterType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GraphicType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.LineType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.RenderType;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.RasterPackage.ERaster;
import com.bbn.openmap.corba.CSpecialist.RasterPackage.RASF_update;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.UpdateGraphic;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.specialist.SGraphic;

public class SRaster
extends SGraphic {
    protected XYPoint p1_;
    protected LLPoint ll1_;
    protected short width_;
    protected short height_;
    protected short x_hot_;
    protected short y_hot_;
    protected byte[] pixels_;
    protected short colorsTotal_;
    protected CTEntry[] ct_;
    protected short transparent_;

    public SRaster() {
        super(GraphicType.GT_Raster, RenderType.RT_Unknown, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(0, 0);
        this.ll1_ = new LLPoint(0.0f, 0.0f);
        this.width_ = 0;
        this.height_ = 0;
        this.x_hot_ = 0;
        this.y_hot_ = 0;
        this.pixels_ = new byte[0];
        this.colorsTotal_ = 0;
        this.transparent_ = 0;
        this.ct_ = new CTEntry[0];
    }

    public SRaster(LLPoint ll1, short width, short height, byte[] pixels, short colorsTotal, CTEntry[] ct, short transparent, short x_hot, short y_hot) {
        super(GraphicType.GT_Raster, RenderType.RT_LatLon, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(0, 0);
        this.ll1_ = ll1;
        this.width_ = width;
        this.height_ = height;
        this.x_hot_ = x_hot;
        this.y_hot_ = y_hot;
        this.pixels_ = pixels;
        this.transparent_ = transparent;
        this.makeMatch(colorsTotal, ct);
    }

    public SRaster(short x1, short y1, short width, short height, byte[] pixels, short colorsTotal, CTEntry[] ct, short transparent, short x_hot, short y_hot) {
        super(GraphicType.GT_Raster, RenderType.RT_XY, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(x1, y1);
        this.ll1_ = new LLPoint(0.0f, 0.0f);
        this.width_ = width;
        this.height_ = height;
        this.x_hot_ = x_hot;
        this.y_hot_ = y_hot;
        this.pixels_ = pixels;
        this.makeMatch(colorsTotal, ct);
        this.transparent_ = transparent;
    }

    public SRaster(LLPoint ll1, short offset_x1, short offset_y1, short width, short height, byte[] pixels, short colorsTotal, CTEntry[] ct, short transparent, short x_hot, short y_hot) {
        super(GraphicType.GT_Raster, RenderType.RT_Offset, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(offset_x1, offset_y1);
        this.ll1_ = ll1;
        this.width_ = width;
        this.height_ = height;
        this.x_hot_ = x_hot;
        this.y_hot_ = y_hot;
        this.pixels_ = pixels;
        this.makeMatch(colorsTotal, ct);
        this.transparent_ = transparent;
    }

    public SRaster(LLPoint ll1, short width, short height, short x_hot, short y_hot) {
        super(GraphicType.GT_Raster, RenderType.RT_LatLon, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(0, 0);
        this.ll1_ = ll1;
        this.width_ = width;
        this.height_ = height;
        this.x_hot_ = x_hot;
        this.y_hot_ = y_hot;
        this.pixels_ = new byte[height * width];
        this.colorsTotal_ = 0;
        this.transparent_ = 0;
        this.ct_ = new CTEntry[0];
    }

    public SRaster(short x1, short y1, short width, short height, short x_hot, short y_hot) {
        super(GraphicType.GT_Raster, RenderType.RT_XY, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(x1, y1);
        this.ll1_ = new LLPoint(0.0f, 0.0f);
        this.width_ = width;
        this.height_ = height;
        this.x_hot_ = x_hot;
        this.y_hot_ = y_hot;
        this.pixels_ = new byte[height * width];
        this.colorsTotal_ = 0;
        this.transparent_ = 0;
        this.ct_ = new CTEntry[0];
    }

    public SRaster(LLPoint ll1, short offset_x1, short offset_y1, short width, short height, short x_hot, short y_hot) {
        super(GraphicType.GT_Raster, RenderType.RT_Offset, LineType.LT_Unknown, DeclutterType.DC_None);
        this.p1_ = new XYPoint(offset_x1, offset_y1);
        this.ll1_ = ll1;
        this.width_ = width;
        this.height_ = height;
        this.x_hot_ = x_hot;
        this.y_hot_ = y_hot;
        this.pixels_ = new byte[height * width];
        this.colorsTotal_ = 0;
        this.transparent_ = 0;
        this.ct_ = new CTEntry[0];
    }

    public boolean setPixel(short x, short y, byte ctIndex) {
        if (this.boundsSafe(x, y)) {
            this.pixels_[y * this.width_ + x] = ctIndex;
            return true;
        }
        return false;
    }

    public byte getPixel(short x, short y) {
        if (this.boundsSafe(x, y)) {
            return this.pixels_[y * this.width_ + x];
        }
        return 0;
    }

    public boolean setColor(int index, CTEntry color) {
        if (index < this.colorsTotal_) {
            this.ct_[index] = color;
            return true;
        }
        return false;
    }

    public CTEntry getColor(int index) {
        if (index < this.colorsTotal_) {
            return this.ct_[index];
        }
        return null;
    }

    private boolean boundsSafe(short x, short y) {
        return y >= 0 && y < this.height_ && x >= 0 && x < this.width_;
    }

    private void makeMatch(short colorsTotal, CTEntry[] ct) {
        if (colorsTotal == ct.length) {
            this.ct_ = ct;
            this.colorsTotal_ = colorsTotal;
        } else if (ct.length > colorsTotal) {
            this.colorsTotal_ = (short)ct.length;
            this.ct_ = ct;
        } else {
            this.ct_ = new CTEntry[colorsTotal];
            for (int i = 0; i < ct.length; ++i) {
                this.ct_[i] = ct[i];
            }
        }
    }

    public void p1(XYPoint p1) {
        this.p1_ = p1;
    }

    public XYPoint p1() {
        return this.p1_;
    }

    public void ll1(LLPoint ll1) {
        this.ll1_ = ll1;
    }

    public LLPoint ll1() {
        return this.ll1_;
    }

    public void width(short width) {
        this.width_ = width;
        this.pixels_ = new byte[this.width_ * this.height_];
    }

    public short width() {
        return this.width_;
    }

    public void height(short height) {
        this.height_ = height;
        this.pixels_ = new byte[this.width_ * this.height_];
    }

    public short height() {
        return this.height_;
    }

    public void x_hot(short x_hot) {
        this.x_hot_ = x_hot;
    }

    public short x_hot() {
        return this.x_hot_;
    }

    public void y_hot(short y_hot) {
        this.y_hot_ = y_hot;
    }

    public short y_hot() {
        return this.y_hot_;
    }

    public void pixels(byte[] pixels) {
        this.pixels_ = pixels;
    }

    public byte[] pixels() {
        return this.pixels_;
    }

    public void colorsTotal(short num_colors) {
        CTEntry[] tmp = this.ct_;
        this.makeMatch(num_colors, tmp);
    }

    public short colorsTotal() {
        return this.colorsTotal_;
    }

    public void ct(CTEntry[] ct) {
        this.makeMatch(this.colorsTotal_, ct);
    }

    public CTEntry[] ct() {
        return this.ct_;
    }

    public void transparent(short transparent) {
        this.transparent_ = transparent;
    }

    public short transparent() {
        return this.transparent_;
    }

    public ERaster fill() {
        return new ERaster(this.eg, this.p1_, this.ll1_, this.pixels_, this.width_, this.height_, this.x_hot_, this.y_hot_, this.colorsTotal_, this.ct_, this.transparent_);
    }

    public UGraphic ufill() {
        UGraphic ugraphic = new UGraphic();
        ugraphic.eras(this.fill());
        return ugraphic;
    }

    public void changeP1(XYPoint p1) {
        this.p1_ = p1;
        RASF_update gupdate = new RASF_update();
        gupdate.p1(p1);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeLl1(LLPoint ll1) {
        this.ll1_ = ll1;
        RASF_update gupdate = new RASF_update();
        gupdate.ll1(ll1);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeWidth(short width) {
        this.width_ = width;
        RASF_update gupdate = new RASF_update();
        gupdate.width(width);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeHeight(short height) {
        this.height_ = height;
        RASF_update gupdate = new RASF_update();
        gupdate.height(height);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeX_hot(short x_hot) {
        this.x_hot_ = x_hot;
        RASF_update gupdate = new RASF_update();
        gupdate.x_hot(x_hot);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeY_hot(short y_hot) {
        this.y_hot_ = y_hot;
        RASF_update gupdate = new RASF_update();
        gupdate.y_hot(y_hot);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changePixels(byte[] pixels) {
        this.pixels_ = pixels;
        RASF_update gupdate = new RASF_update();
        gupdate.pixels(pixels);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeColorsTotal(short num_colors) {
        this.colorsTotal_ = num_colors;
        RASF_update gupdate = new RASF_update();
        gupdate.colorsTotal(num_colors);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeCt(CTEntry[] ct) {
        this.ct_ = ct;
        RASF_update gupdate = new RASF_update();
        gupdate.ct(ct);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }

    public void changeTransparent(short transparent) {
        this.transparent_ = transparent;
        RASF_update gupdate = new RASF_update();
        gupdate.transparent(transparent);
        UpdateGraphic ug = new UpdateGraphic();
        ug.rasf_update(gupdate);
        this.addGraphicChange(ug);
    }
}

