/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import java.applet.Applet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Debug {
    public static String ERROR_HEADER = "\n*** ERROR ***";
    public static String ERROR_TAIL = "*************";
    public static final boolean On = true;
    public static PrintStream out = System.out;
    protected static PrintStream err = System.err;
    protected static File errorFile = null;
    protected static boolean notifyOut = true;
    protected static boolean notifyErr = true;
    protected static DataOutputStream outputLog = null;
    protected static DataOutputStream errorLog = null;
    protected static boolean errorAppend = false;
    public static boolean debugAll = false;
    public static String debugAllToken = "all";
    private static Hashtable dbgTable = new Hashtable();
    private static String debugTokenHeader = "debug.";

    private Debug() {
    }

    public static void init(Applet applet, String[] parameters) {
        if (applet == null) {
            try {
                Debug.init(System.getProperties());
            }
            catch (SecurityException securityException) {}
        } else if (parameters != null) {
            try {
                for (int i = 0; i < parameters.length; ++i) {
                    String pname = parameters[i];
                    if (!pname.startsWith(debugTokenHeader) || applet.getParameter(parameters[i]) == null) continue;
                    String token = pname.substring(debugTokenHeader.length());
                    dbgTable.put(token, Boolean.TRUE);
                }
                if (applet.getParameter(debugTokenHeader + debugAllToken) != null) {
                    dbgTable.put(debugAllToken, Boolean.TRUE);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        Debug.postInit();
    }

    public static void init(Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.startsWith(debugTokenHeader)) continue;
            String token = name.substring(debugTokenHeader.length());
            dbgTable.put(token, Boolean.TRUE);
        }
        Debug.postInit();
    }

    public static void init() {
        Properties p;
        try {
            p = System.getProperties();
        }
        catch (AccessControlException ace) {
            p = new Properties();
        }
        Debug.init(p);
    }

    private static void postInit() {
        debugAll = dbgTable.containsKey(debugAllToken);
    }

    public static boolean debugging(String token) {
        return debugAll || dbgTable.containsKey(token);
    }

    public static void put(String dbgToken) {
        dbgTable.put(dbgToken, Boolean.TRUE);
    }

    public static void remove(String dbgToken) {
        dbgTable.remove(dbgToken);
    }

    public static void message(String dbgToken, String message) {
        if (Debug.debugging(dbgToken)) {
            Debug.output(message);
        }
    }

    public static void setPrintStream(PrintStream out) {
        Debug.out = out;
    }

    public static PrintStream getPrintStream() {
        return out;
    }

    public static void directOutput(File file, boolean alsoToOutStream) {
        try {
            Debug.directOutput(new FileOutputStream(file), alsoToOutStream);
        }
        catch (IOException ioe) {
            notifyOut = true;
            out = System.out;
            Debug.error("Debug: can't set up <" + file + "> for log file! \n" + ioe);
            return;
        }
    }

    public static void directOutput(String filename, boolean append, boolean alsoToOutStream) {
        try {
            Debug.directOutput(new FileOutputStream(filename, append), alsoToOutStream);
        }
        catch (IOException ioe) {
            notifyOut = true;
            out = System.out;
            Debug.error("Debug: can't set up <" + filename + "> for log file! \n" + ioe);
            return;
        }
    }

    public static void directOutput(OutputStream os, boolean alsoToOutStream) {
        outputLog = new DataOutputStream(os);
        notifyOut = alsoToOutStream;
    }

    public static void setErrorStream(PrintStream err) {
        Debug.err = err;
    }

    public static PrintStream getErrorStream() {
        return err;
    }

    public static void directErrors(File file, boolean alsoToErrStream) {
        errorFile = file;
        notifyErr = alsoToErrStream;
    }

    public static void directErrors(String filename, boolean append, boolean alsoToErrStream) {
        errorAppend = append;
        errorFile = new File(filename);
        notifyErr = alsoToErrStream;
    }

    public static void directErrors(OutputStream os, boolean alsoToErrStream) {
        errorLog = new DataOutputStream(os);
        notifyErr = alsoToErrStream;
    }

    public static void error(String errorString) {
        try {
            if (errorLog == null) {
                if (errorFile != null) {
                    FileOutputStream log = new FileOutputStream(errorFile.getPath(), errorAppend);
                    errorLog = new DataOutputStream(log);
                    errorLog.writeBytes("\n");
                    errorLog.writeBytes(Debug.getMapBeanMessage());
                    errorLog.writeBytes("\n");
                    errorLog.writeBytes("ERROR log file - " + Calendar.getInstance().getTime());
                    errorLog.writeBytes("\n");
                    errorLog.writeBytes(ERROR_TAIL);
                    errorLog.writeBytes(ERROR_TAIL);
                    errorLog.writeBytes(ERROR_TAIL);
                    errorLog.writeBytes("\n");
                    errorLog.writeBytes(ERROR_HEADER);
                    errorLog.writeBytes(errorString);
                    errorLog.writeBytes("\n");
                    errorLog.writeBytes(ERROR_TAIL);
                    errorLog.writeBytes("\n");
                }
            } else {
                errorLog.writeBytes(ERROR_HEADER);
                errorLog.writeBytes("\n");
                errorLog.writeBytes(errorString);
                errorLog.writeBytes("\n");
                errorLog.writeBytes(ERROR_TAIL);
                errorLog.writeBytes("\n");
            }
        }
        catch (IOException ioe) {
            errorFile = null;
            notifyErr = true;
            err = System.err;
            err.println(ERROR_HEADER);
            err.println("Debug: error writing <" + errorString + "> to log! \n" + ioe);
            err.println(ERROR_TAIL);
            return;
        }
        if (notifyErr) {
            err.println(ERROR_HEADER);
            err.println(errorString);
            err.println(ERROR_TAIL);
        }
    }

    public static String getMapBeanMessage() {
        String message = "";
        try {
            Class<?> mbClass = Class.forName("com.bbn.openmap.MapBean");
            Method crMessage = mbClass.getDeclaredMethod("getCopyrightMessage", null);
            message = (String)crMessage.invoke(mbClass, (Object[])null);
        }
        catch (InvocationTargetException ite) {
            System.out.println(ite.getMessage());
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (IllegalAccessException iae2) {
            System.out.println(iae2.getMessage());
        }
        catch (NoSuchMethodException nme) {
            System.out.println(nme.getMessage());
        }
        catch (NullPointerException npe) {
            System.out.println(npe.getMessage());
        }
        catch (SecurityException se) {
            System.out.println(se.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.getMessage());
        }
        return message;
    }

    public static void output() {
        Debug.output("");
    }

    public static void output(String outputString) {
        try {
            if (outputLog != null) {
                outputLog.writeBytes(outputString);
                outputLog.writeBytes("\n");
            }
        }
        catch (IOException ioe) {
            notifyOut = true;
            out = System.out;
            Debug.error("Debug: output writing <" + outputString + "> to log! \n" + ioe);
            return;
        }
        if (notifyOut) {
            out.println(outputString);
        }
    }

    public static void setLog(File file, boolean alsoToStreams) {
        try {
            FileOutputStream logStream = new FileOutputStream(file);
            Debug.setLog(logStream, alsoToStreams);
        }
        catch (IOException ioe) {
            Debug.resetOutput();
            Debug.error("IOException trying to create a log file.\n" + ioe);
        }
    }

    public static void setLog(OutputStream logStream, boolean alsoToStreams) {
        DataOutputStream dos;
        outputLog = dos = new DataOutputStream(logStream);
        errorLog = dos;
        errorFile = null;
        notifyErr = alsoToStreams;
        notifyOut = alsoToStreams;
    }

    public static void resetOutput() {
        notifyOut = true;
        errorFile = null;
        notifyErr = true;
        err = System.err;
        out = System.out;
    }

    public static void sampleUsage() {
        if (Debug.debugging("debug")) {
            Debug.output("debug message");
        } else {
            Debug.output("try again");
        }
    }

    public static void main(String[] args) {
        Debug.init(System.getProperties());
        Debug.sampleUsage();
    }
}

