/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.terrain;

import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LOSGenerator {
    static final int PRECISE = 0;
    static final int GOODENOUGH = 1;
    static final int AZIMUTH = 2;
    static final int DEFAULT_INVISIBLE = new Color(0, 0, 0, 0).getRGB();
    static final int DEFAULT_VISIBLE = new Color(0, 255, 0, 255).getRGB();
    static final int DEFAULT_MAYBEVISIBLE = new Color(255, 255, 0, 255).getRGB();
    protected int INVISIBLE = DEFAULT_INVISIBLE;
    protected int VISIBLE = DEFAULT_VISIBLE;
    protected int MAYBEVISIBLE = DEFAULT_MAYBEVISIBLE;
    DTEDFrameCache dtedCache = null;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.tools.terrain.LOSGenerator");

    public LOSGenerator() {
    }

    public LOSGenerator(DTEDFrameCache cache) {
        this.setDtedCache(cache);
    }

    public void setDtedCache(DTEDFrameCache cache) {
        this.dtedCache = cache;
    }

    public DTEDFrameCache getDtedCache() {
        return this.dtedCache;
    }

    public boolean isLOS(LatLonPoint startLLP, int startObjHeight, boolean addStartElevation, LatLonPoint endLLP, int endObjHeight, int numPoints) {
        boolean ret = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("LOSGenerator.isLOS: " + startLLP + " at height:" + startObjHeight + ", " + endLLP + " at height:" + endObjHeight + ", numPoints = " + numPoints);
        }
        if (this.dtedCache == null) {
            return ret;
        }
        int startTotalHeight = startObjHeight + (addStartElevation ? this.dtedCache.getElevation(startLLP.getLatitude(), startLLP.getLongitude()) : 0);
        double[] llpoints = GreatCircle.greatCircle(startLLP.getRadLat(), startLLP.getRadLon(), endLLP.getRadLat(), endLLP.getRadLon(), numPoints, true);
        LatLonPoint.Double llp = new LatLonPoint.Double();
        int gcPointListSize = llpoints.length;
        double smallestSlopeValue = -Math.PI;
        for (int i = 4; i < gcPointListSize; i += 2) {
            double slopeOfCurrentPoint;
            ((LatLonPoint)llp).setLatLon(llpoints[i], llpoints[i + 1], true);
            int heightAboveGround = 0;
            if (i >= gcPointListSize - 2) {
                heightAboveGround = endObjHeight;
            }
            if ((slopeOfCurrentPoint = this.calculateLOSSlope(startLLP, startTotalHeight, llp, heightAboveGround)) > smallestSlopeValue) {
                smallestSlopeValue = slopeOfCurrentPoint;
                ret = true;
            } else {
                ret = false;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("   LOS:" + i / 2 + " - slope = " + Length.DECIMAL_DEGREE.fromRadians(slopeOfCurrentPoint) + " at height of point: " + heightAboveGround + (ret ? " *" : " -"));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("LOSGenerator - points " + (ret ? "" : " NOT ") + " in LOS");
        }
        return ret;
    }

    public double calculateLOSSlope(LatLonPoint startLLP, int startTotalHeight, LatLonPoint endLLP, int endObjHeight) {
        if (this.dtedCache == null) {
            return 0.0;
        }
        double arc_dist = startLLP.distance(endLLP);
        int endTotalHeight = endObjHeight + this.dtedCache.getElevation(endLLP.getLatitude(), endLLP.getLongitude());
        return LOSGenerator.calculateLOSSlope(startTotalHeight, endTotalHeight, arc_dist);
    }

    public static double calculateLOSSlope(int startTotalHeight, int endTotalHeight, double arc_dist) {
        double ret = 0.0;
        double P = Math.sin(arc_dist) * (double)((float)endTotalHeight + 6378137.0f);
        double xPrime = Math.cos(arc_dist) * (double)((float)endTotalHeight + 6378137.0f);
        double cutoff = (float)startTotalHeight + 6378137.0f;
        double bottom = cutoff - xPrime;
        ret = 1.5707963267948966 - Math.atan(bottom / P);
        return ret;
    }
}

