/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.icon.IconPart;
import com.bbn.openmap.tools.icon.IconPartCollectionEntry;
import com.bbn.openmap.tools.icon.IconPartList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconPartCollection
extends IconPartCollectionEntry {
    protected Map<String, IconPartCollectionEntry> entryMap;
    protected List<IconPartCollection> collections;

    protected IconPartCollection() {
    }

    public IconPartCollection(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public void add(IconPartCollectionEntry entry) {
        if (entry != null) {
            String entryName = entry.getName();
            if (entryName != null) {
                this.getEntryMap().put(entryName.intern(), entry);
            }
            if (entry instanceof IconPartCollection) {
                this.getCollections().add((IconPartCollection)entry);
            }
        }
    }

    public Object remove(IconPartCollectionEntry entry) {
        return this.getEntryMap().remove(entry.getName());
    }

    public void clear() {
        this.getEntryMap().clear();
    }

    public Set<String> keySet() {
        return this.getEntryMap().keySet();
    }

    public IconPart get(String name, DrawingAttributes da) {
        IconPart ip = this.get(name);
        if (ip != null) {
            ip.setRenderingAttributes(da);
        }
        return ip;
    }

    public IconPart get(String name) {
        IconPart part;
        block2: {
            IconPartCollection ipc;
            IconPartCollectionEntry entry = this.getEntryMap().get(name.intern());
            part = null;
            if (entry != null) {
                part = (IconPart)entry.getIconPart().clone();
            }
            if (part != null) break block2;
            Iterator<IconPartCollection> iterator = this.collections.iterator();
            while (iterator.hasNext() && (part = (ipc = iterator.next()).get(name)) == null) {
            }
        }
        return part;
    }

    public String getDescription(String name) {
        String desc;
        block2: {
            IconPartCollection ipc;
            IconPartCollectionEntry entry = this.getEntryMap().get(name.intern());
            desc = null;
            if (entry != null) {
                desc = entry.getDescription();
            }
            if (desc != null) break block2;
            Iterator<IconPartCollection> iterator = this.collections.iterator();
            while (iterator.hasNext() && (desc = (ipc = iterator.next()).getDescription(name)) == null) {
            }
        }
        return desc;
    }

    public IconPart compose(List<String> list) {
        IconPartList ipl = new IconPartList();
        for (String partName : list) {
            IconPart part = this.get(partName);
            if (part == null) continue;
            ipl.add(part);
        }
        return ipl;
    }

    public List<String> composeDescription(List<String> list) {
        LinkedList<String> ll = new LinkedList<String>();
        for (String entry : list) {
            String des = this.getDescription(entry);
            if (des == null) continue;
            ll.add(des);
        }
        return ll;
    }

    protected void setEntryMap(Map<String, IconPartCollectionEntry> map) {
        this.entryMap = map;
    }

    protected Map<String, IconPartCollectionEntry> getEntryMap() {
        if (this.entryMap == null) {
            this.entryMap = new Hashtable<String, IconPartCollectionEntry>();
        }
        return this.entryMap;
    }

    protected void setCollections(List<IconPartCollection> list) {
        this.collections = list;
    }

    protected List<IconPartCollection> getCollections() {
        if (this.collections == null) {
            this.collections = new LinkedList<IconPartCollection>();
        }
        return this.collections;
    }

    @Override
    public void setIconPart(IconPart part) {
        this.part = part;
    }

    @Override
    public IconPart getIconPart() {
        return this.part;
    }
}

