/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.grid.ColorGeneratorLoader;
import com.bbn.openmap.omGraphics.grid.ElevationBandGenerator;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ElevationBandGeneratorLoader
extends ColorGeneratorLoader {
    public static final String DISPLAY_UNITS_PROPERTY = "DISPLAY_UNITS";
    public static final String BANDHEIGHT_PROPERTY = "BANDHEIGHT";
    protected Length displayUnits = Length.METER;
    protected int bandHeight = 100;
    private static final Integer sliderLabelKey = new Integer(250);

    public void setDisplayUnits(Length units) {
        Length oldValue = this.displayUnits;
        this.displayUnits = units;
        if (oldValue != this.displayUnits) {
            this.firePropertyChange(DISPLAY_UNITS_PROPERTY, (Object)oldValue, (Object)this.displayUnits);
        }
    }

    public Length getDisplayUnits() {
        return this.displayUnits;
    }

    public int getBandHeight() {
        return this.bandHeight;
    }

    public void setBandHeight(int bh) {
        int oldValue = this.bandHeight;
        this.bandHeight = bh;
        if (oldValue != this.bandHeight) {
            this.firePropertyChange(BANDHEIGHT_PROPERTY, new Integer(oldValue), new Integer(this.bandHeight));
        }
    }

    protected String getUnitAdjustmentTitle() {
        return "Band Height Units";
    }

    protected String getValueAdjustmentTitle() {
        return "Band Height Value";
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        panel.setLayout(gridbag);
        JPanel unitPanel = PaletteHelper.createPaletteJPanel(this.getUnitAdjustmentTitle());
        Object[] units = new Object[]{Length.METER, Length.FEET};
        JComboBox<Object> unitBox = new JComboBox<Object>(units);
        unitBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JComboBox unitBox = (JComboBox)ae.getSource();
                ElevationBandGeneratorLoader.this.setDisplayUnits((Length)((Object)unitBox.getSelectedItem()));
            }
        });
        unitPanel.add(unitBox);
        gridbag.setConstraints(unitPanel, c);
        panel.add(unitPanel);
        JPanel contrastPanel = PaletteHelper.createPaletteJPanel(this.getValueAdjustmentTitle());
        JSlider contrastSlide = new JSlider(0, 1, 500, this.getBandHeight());
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        dict.put(new Integer(1), new JLabel("1"));
        dict.put(new Integer(500), new JLabel("500"));
        dict.put(sliderLabelKey, new JLabel("(" + this.getBandHeight() + ")"));
        contrastSlide.setLabelTable(dict);
        contrastSlide.setPaintLabels(true);
        contrastSlide.setMajorTickSpacing(50);
        contrastSlide.setPaintTicks(true);
        contrastSlide.setSnapToTicks(false);
        contrastSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider slider = (JSlider)ce.getSource();
                if (!slider.getValueIsAdjusting()) {
                    int value = slider.getValue();
                    JLabel label = (JLabel)slider.getLabelTable().get(sliderLabelKey);
                    label.setText("(" + value + ")");
                    ElevationBandGeneratorLoader.this.setBandHeight(value);
                }
            }
        });
        contrastPanel.add(contrastSlide);
        gridbag.setConstraints(contrastPanel, c);
        panel.add(contrastPanel);
        return panel;
    }

    public OMGridGenerator getGenerator() {
        ElevationBandGenerator gen = new ElevationBandGenerator();
        gen.setColors(this.getColors());
        gen.setDisplayUnits(this.displayUnits);
        gen.setBandHeight(this.getBandHeight());
        return gen;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        super.addPropertyChangeListener(DISPLAY_UNITS_PROPERTY, pcl);
        super.addPropertyChangeListener(BANDHEIGHT_PROPERTY, pcl);
        super.addPropertyChangeListener("COLORS", pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        super.removePropertyChangeListener(DISPLAY_UNITS_PROPERTY, pcl);
        super.removePropertyChangeListener(BANDHEIGHT_PROPERTY, pcl);
        super.removePropertyChangeListener("COLORS", pcl);
    }
}

