/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.omGraphics.NatCubicSpline;

public class NatCubicClosedSpline
extends NatCubicSpline {
    NatCubicSpline.Cubic[] calcNaturalCubic(int n, int[] x) {
        int k;
        float[] w = new float[n + 1];
        float[] v = new float[n + 1];
        float[] y = new float[n + 1];
        float[] D = new float[n + 1];
        float z = 0.25f;
        v[1] = 0.25f;
        w[1] = 0.25f;
        y[0] = z * 3.0f * (float)(x[1] - x[n]);
        float H = 4.0f;
        float F = 3 * (x[0] - x[n - 1]);
        float G = 1.0f;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0f / (4.0f - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * ((float)(3 * (x[k + 1] - x[k - 1])) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0f) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0f) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        NatCubicSpline.Cubic[] C = new NatCubicSpline.Cubic[n + 1];
        for (k = 0; k < n; ++k) {
            C[k] = new NatCubicSpline.Cubic(this, x[k], D[k], (float)(3 * (x[k + 1] - x[k])) - 2.0f * D[k] - D[k + 1], (float)(2 * (x[k] - x[k + 1])) + D[k] + D[k + 1]);
        }
        C[n] = new NatCubicSpline.Cubic(this, x[n], D[n], (float)(3 * (x[0] - x[n])) - 2.0f * D[n] - D[0], (float)(2 * (x[n] - x[0])) + D[n] + D[0]);
        return C;
    }

    public float[][] calc(int[] xpoints, int[] ypoints) {
        int[] xpts = xpoints;
        int[] ypts = ypoints;
        int l = xpoints.length;
        if (xpoints.length > 2 && xpoints[0] == xpoints[l - 1] && ypoints[0] == ypoints[l - 1]) {
            xpts = new int[l - 1];
            System.arraycopy(xpoints, 0, xpts, 0, l - 1);
            ypts = new int[l - 1];
            System.arraycopy(ypoints, 0, ypts, 0, l - 1);
        }
        return super.calc(xpts, ypts);
    }

    public double[] calc(double[] llpoints, double precision) {
        double[] llpts = llpoints;
        int l = llpoints.length;
        if (l > 4 && MoreMath.approximately_equal(llpoints[0], llpoints[l - 2]) && MoreMath.approximately_equal(llpoints[1], llpoints[l - 1])) {
            llpts = new double[l - 2];
            System.arraycopy(llpoints, 0, llpts, 0, l - 2);
        }
        return super.calc(llpts, precision);
    }
}

