/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.MakeToc;
import com.bbn.openmap.layer.rpf.MakeTocException;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.layer.rpf.RpfTocEntry;
import com.bbn.openmap.layer.rpf.RpfTocHandler;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfUtil {
    public static final char SCALE_EQUALS = 'e';
    public static final char SCALE_NOTEQUALS = 'n';
    public static final char SCALE_GREATERTHAN = 'g';
    public static final char SCALE_LESSTHAN = 'l';
    public static final float ALL_SCALES = 0.0f;
    public static final int BOUNDED = 0;
    public static final int INSIDE = 1;
    public static final int OUTSIDE = 2;
    protected int boundaryLimits = 0;
    protected float scale = 0.0f;
    protected char scaleDelim = (char)101;
    protected float upperLat = 90.0f;
    protected float leftLon = -180.0f;
    protected float lowerLat = -90.0f;
    protected float rightLon = 180.0f;
    protected String rpfDir;
    protected boolean verbose = false;
    protected List<String> frameList;

    public RpfUtil() {
    }

    public RpfUtil(float ulat, float llon, float llat, float rlon) {
        this(null, ulat, llon, llat, rlon, 0.0f, 'e', 0);
    }

    public RpfUtil(String rpfDir, float ulat, float llon, float llat, float rlon) {
        this(rpfDir, ulat, llon, llat, rlon, 0.0f, 'e', 0);
    }

    public RpfUtil(String rpfDir, float ulat, float llon, float llat, float rlon, float scale, char scaleDelimiter, int boundaryLimits) {
        this.upperLat = ulat;
        this.lowerLat = llat;
        this.leftLon = llon;
        this.rightLon = rlon;
        this.scale = scale;
        this.scaleDelim = scaleDelimiter;
        this.boundaryLimits = boundaryLimits;
        this.setRpfDir(rpfDir);
    }

    protected List<String> organizeFrames(String rpfDir) {
        RpfTocHandler toc = new RpfTocHandler(rpfDir);
        LinkedList<String> frameList = new LinkedList<String>();
        if (toc.isValid()) {
            RpfTocEntry[] entries = toc.getEntries();
            if (this.verbose) {
                Debug.output("Figuring out which frames fit the criteria...");
            }
            for (int i = 0; i < entries.length; ++i) {
                RpfTocEntry entry = entries[i];
                toc.loadFrameInformation(entry);
                double udinterval = (entry.coverage.nw_lat - entry.coverage.se_lat) / (double)entry.vertFrames;
                double rlinterval = (entry.coverage.se_lon - entry.coverage.nw_lon) / (double)entry.horizFrames;
                if (this.scale > 0.0f) {
                    float rectScale = RpfTocHandler.textScaleToLong(entry.scale);
                    if (rectScale == RpfProductInfo.UK.scale) {
                        if (!this.verbose) continue;
                        Debug.output("  RpfTocEntry[" + i + "] scale unknown (" + entry.coverage.chartCode + "), skipping");
                        continue;
                    }
                    switch (this.scaleDelim) {
                        case 'e': {
                            if (this.scale != rectScale) break;
                            frameList.addAll(this.getFrameList(entry, rlinterval, udinterval));
                            break;
                        }
                        case 'g': {
                            if (!(this.scale >= rectScale)) break;
                            frameList.addAll(this.getFrameList(entry, rlinterval, udinterval));
                            break;
                        }
                        case 'l': {
                            if (!(this.scale <= rectScale)) break;
                            frameList.addAll(this.getFrameList(entry, rlinterval, udinterval));
                            break;
                        }
                        case 'n': {
                            if (this.scale == rectScale) break;
                            frameList.addAll(this.getFrameList(entry, rlinterval, udinterval));
                        }
                    }
                    continue;
                }
                frameList.addAll(this.getFrameList(entry, rlinterval, udinterval));
            }
        }
        return frameList;
    }

    protected List<String> getFrameList(RpfTocEntry entry, double rlinterval, double udinterval) {
        LinkedList<String> frameList = new LinkedList<String>();
        for (int hor = 0; hor < entry.horizFrames; ++hor) {
            for (int ver = 0; ver < entry.vertFrames; ++ver) {
                RpfFrameEntry frame = entry.getFrame(ver, hor);
                double left = entry.coverage.nw_lon + rlinterval * (double)hor;
                double right = left + rlinterval;
                double up = entry.coverage.nw_lat - udinterval * (double)ver;
                double down = up - udinterval;
                if (!frame.exists || !this.frameFitsCriteria(left, right, up, down, rlinterval, udinterval)) continue;
                String name = frame.framePath.substring(frame.rpfdirIndex + 3);
                frameList.add(name);
                if (!this.verbose) continue;
                Debug.output(" getFrameList: adding file " + name);
            }
        }
        return frameList;
    }

    protected boolean frameFitsCriteria(double left, double right, double up, double down, double rlinterval, double udinterval) {
        switch (this.boundaryLimits) {
            case 2: {
                return left < (double)this.leftLon && right < (double)this.leftLon || left > (double)this.rightLon && right > (double)this.rightLon || up < (double)this.lowerLat && down < (double)this.lowerLat || up > (double)this.upperLat && down > (double)this.upperLat;
            }
            case 1: {
                return left > (double)this.leftLon && right > (double)this.leftLon && left < (double)this.rightLon && right < (double)this.rightLon && up > (double)this.lowerLat && down > (double)this.lowerLat && up < (double)this.upperLat && down < (double)this.upperLat;
            }
        }
        return (right <= (double)this.rightLon && left >= (double)this.leftLon - rlinterval || left >= (double)this.leftLon && right <= (double)this.rightLon + rlinterval || left <= (double)this.leftLon && right >= (double)this.rightLon) && (up <= (double)this.upperLat + udinterval && down >= (double)this.lowerLat || down >= (double)this.lowerLat - udinterval && up <= (double)this.upperLat || up >= (double)this.upperLat && down <= (double)this.lowerLat);
    }

    public boolean copy(String toRpfDir) {
        File toDir = new File(toRpfDir);
        boolean ret = false;
        String sourceRpfDir = this.getRpfDir();
        if ((toDir.exists() || toDir.mkdirs()) && this.frameList != null) {
            if (this.verbose) {
                Debug.output("From " + sourceRpfDir + " to " + toRpfDir + ":");
            }
            Iterator<String> it = this.frameList.iterator();
            while (it.hasNext()) {
                String relativeFilePath = "/" + it.next();
                File fromFile = new File(sourceRpfDir + relativeFilePath);
                File toFile = new File(toRpfDir + relativeFilePath);
                File toParent = toFile.getParentFile();
                if (!toParent.exists()) {
                    toParent.mkdirs();
                }
                if (this.verbose) {
                    Debug.output("Copying " + relativeFilePath);
                }
                try {
                    FileUtils.copy(fromFile, toFile, 400000);
                }
                catch (IOException ioe) {
                    Debug.error("RpfUtil.copy:  IOExeption copying files: " + ioe.getMessage());
                    return false;
                }
            }
            ret = true;
        }
        return ret;
    }

    public boolean maketoc(String rpfDir) {
        boolean ret = false;
        MakeToc mt = new MakeToc();
        String[] paths = new String[]{rpfDir};
        paths = mt.searchForRpfFiles(paths);
        try {
            mt.create(paths, rpfDir + "/" + "A.TOC", false);
            ret = true;
        }
        catch (MakeTocException mte) {
            Debug.error("Problem creating A.TOC file: \n" + mte.getMessage());
        }
        return ret;
    }

    public boolean delete(String rpfDir) {
        boolean ret = false;
        List<String> frameList = this.organizeFrames(rpfDir);
        if (frameList != null) {
            Iterator<String> it = frameList.iterator();
            while (it.hasNext()) {
                String relativeFilePath = "/" + it.next();
                File fromFile = new File(rpfDir + relativeFilePath);
                if (!fromFile.exists() || !fromFile.delete() || !this.verbose) continue;
                Debug.output("Deleting " + fromFile.getPath());
            }
            ret = true;
        }
        return ret;
    }

    public boolean zip(String zipLocation, String toBeZippedName) {
        File toBeZipped;
        boolean ret = false;
        if (this.verbose) {
            Debug.put("zip");
        }
        if ((toBeZipped = new File(toBeZippedName)).exists()) {
            try {
                FileUtils.saveZipFile(zipLocation, toBeZipped);
                ret = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public void query(String rpfDir) {
        List<String> frameList = this.organizeFrames(rpfDir);
        if (frameList != null) {
            Iterator<String> it = frameList.iterator();
            while (it.hasNext()) {
                Debug.output(it.next().toString());
            }
        }
    }

    public static void main(String[] args) {
        Debug.init();
        ArgParser ap = new ArgParser("RpfUtil");
        ap.add("copy", "Copy RPF data from one RPF directory to another. (-copy from to)", 2);
        ap.add("delete", "Delete RPF data from a RPF directory. (-delete from)", 1);
        ap.add("maketoc", "Create an A.TOC file in a RPF directory. (-maketoc from).", 1);
        ap.add("zip", "Create a zip file from a RPF directory. (-zip zipFileName from)", 2);
        ap.add("query", "Print the paths of files that fit the criteria, but do nothing", 1);
        ap.add("scale", "The scale to use for criteria in matching chart types, followed by a letter describing the relationship of matching frame scales to give scale ('g'reater than, 'l'ess than, 'n'ot equal to, 'e'qual to). (optional)", 2);
        ap.add("boundary", "Coordinates of bounding box (upper lat, left lon, lower lat, right lon) (optional)", 4, true);
        ap.add("inside", "Flag to manage RPF frames inside bounding box. (default, optional)");
        ap.add("outside", "Flag to manage RPF frames outside bounding box. (optional)");
        ap.add("verbose", "Print out progress");
        ap.add("extraverbose", "Print out ALL progress");
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        float ulat = 90.0f;
        float llat = -90.0f;
        float llon = -180.0f;
        float rlon = 180.0f;
        String[] arg = ap.getArgValues("boundary");
        if (arg != null) {
            boolean boundaryCoordinateProblem = true;
            try {
                ulat = Float.parseFloat(arg[0]);
                llon = Float.parseFloat(arg[1]);
                llat = Float.parseFloat(arg[2]);
                rlon = Float.parseFloat(arg[3]);
                boundaryCoordinateProblem = ulat > 90.0f || llon < -180.0f || llat < -90.0f || rlon > 180.0f || ulat <= llat || llon >= rlon;
            }
            catch (NumberFormatException nfe) {
                Debug.error("Parsing error for boundary coordinates");
            }
            if (boundaryCoordinateProblem) {
                Debug.error("Boundary coordinates are screwy...");
                ap.printUsage();
                System.exit(0);
            }
        }
        RpfUtil rpfUtil = new RpfUtil(ulat, llon, llat, rlon);
        rpfUtil.verbose = ap.getArgValues("verbose") != null;
        arg = ap.getArgValues("outside");
        if (arg != null) {
            rpfUtil.setBoundaryLimits(2);
        }
        if ((arg = ap.getArgValues("inside")) != null) {
            rpfUtil.setBoundaryLimits(1);
        }
        if ((arg = ap.getArgValues("scale")) != null) {
            try {
                rpfUtil.setScale(Float.parseFloat(arg[0]));
                rpfUtil.setScaleDelim(arg[1].charAt(0));
            }
            catch (NumberFormatException nfe) {
                Debug.error("Scale value is screwy...");
                ap.printUsage();
                System.exit(0);
            }
        }
        if ((arg = ap.getArgValues("query")) != null) {
            rpfUtil.query(arg[0]);
            System.exit(0);
        }
        if ((arg = ap.getArgValues("copy")) != null) {
            rpfUtil.setRpfDir(arg[0]);
            if (!rpfUtil.copy(arg[1])) {
                Debug.output("Problem copying frames");
            }
        }
        if ((arg = ap.getArgValues("delete")) != null && !rpfUtil.delete(arg[0])) {
            Debug.output("Problem deleting files.");
        }
        if ((arg = ap.getArgValues("maketoc")) != null && !rpfUtil.maketoc(arg[0])) {
            Debug.output("Problem creating A.TOC file for frames.");
        }
        if ((arg = ap.getArgValues("zip")) != null && !rpfUtil.zip(arg[0], arg[1])) {
            Debug.output("Problem creating zip file: " + arg[0]);
        }
    }

    public int getBoundaryLimits() {
        return this.boundaryLimits;
    }

    public void setBoundaryLimits(int boundaryLimits) {
        this.boundaryLimits = boundaryLimits;
    }

    public List<String> getFrameList() {
        return this.frameList;
    }

    public void setFrameList(List<String> frameList) {
        this.frameList = frameList;
    }

    public float getLeftLon() {
        return this.leftLon;
    }

    public void setLeftLon(float leftLon) {
        this.leftLon = leftLon;
    }

    public float getLowerLat() {
        return this.lowerLat;
    }

    public void setLowerLat(float lowerLat) {
        this.lowerLat = lowerLat;
    }

    public float getRightLon() {
        return this.rightLon;
    }

    public void setRightLon(float rightLon) {
        this.rightLon = rightLon;
    }

    public String getRpfDir() {
        return this.rpfDir;
    }

    public void setRpfDir(String rpfDir) {
        this.rpfDir = rpfDir;
        if (rpfDir != null) {
            this.frameList = this.organizeFrames(rpfDir);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public char getScaleDelim() {
        return this.scaleDelim;
    }

    public void setScaleDelim(char scaleDelim) {
        this.scaleDelim = scaleDelim == 'n' || scaleDelim == 'g' || scaleDelim == 'l' ? scaleDelim : (char)101;
    }

    public float getUpperLat() {
        return this.upperLat;
    }

    public void setUpperLat(float upperLat) {
        this.upperLat = upperLat;
    }
}

