/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.dted.DTEDCacheManager;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.omGraphics.event.StandardMapMouseInterpreter;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DTEDLayer
extends OMGraphicHandlerLayer {
    protected transient DTEDCacheManager cache = null;
    protected boolean cancelled = false;
    protected String[] paths;
    protected int dtedLevel = 0;
    protected int viewType = 0;
    protected int bandHeight = 25;
    protected int slopeAdjust = 3;
    protected int numColors = 216;
    protected int opaqueness = 255;
    protected boolean killCache = true;
    protected int cacheSize = 20;
    public static final String DTEDPathsProperty = "paths";
    public static final String DTED2PathsProperty = "level2.paths";
    public static final String OpaquenessProperty = "opaque";
    public static final String NumColorsProperty = "number.colors";
    public static final String DTEDLevelProperty = "level";
    public static final String DTEDViewTypeProperty = "view.type";
    public static final String DTEDSlopeAdjustProperty = "contrast";
    public static final String DTEDBandHeightProperty = "band.height";
    public static final String DTEDMinScaleProperty = "min.scale";
    public static final String DTEDKillCacheProperty = "kill.cache";
    public static final String DTEDFrameCacheSizeProperty = "cacheSize";
    private String level0Command = "setLevelTo0";
    private String level1Command = "setLevelTo1";
    private String level2Command = "setLevelTo2";
    DTEDLocation location = null;
    protected Box paletteBox = null;

    public DTEDLayer() {
        this(null);
    }

    public DTEDLayer(String[] pathsToDTEDDirs) {
        this.setName("DTED");
        this.setDefaultValues();
        this.setPaths(pathsToDTEDDirs);
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public void setPaths(String[] pathsToDTEDDirs) {
        this.paths = pathsToDTEDDirs;
        if (this.cache != null) {
            this.cache.setDtedDirPaths(pathsToDTEDDirs);
        }
    }

    public String[] getPaths() {
        return this.paths;
    }

    public DTEDCacheManager getCache() {
        if (this.cache == null) {
            this.cache = new DTEDCacheManager(this.paths, this.numColors, this.opaqueness);
            this.cache.setCacheSize(this.cacheSize);
            DTEDFrameSubframeInfo dfsi = new DTEDFrameSubframeInfo(this.viewType, this.bandHeight, this.dtedLevel, this.slopeAdjust);
            this.cache.setSubframeInfo(dfsi);
        }
        return this.cache;
    }

    public void setCache(DTEDCacheManager cache) {
        this.cache = cache;
    }

    protected void setDefaultValues() {
        this.paths = null;
        this.setOpaqueness(255);
        this.setDtedLevel(0);
        this.setBandHeight(25);
        this.setSlopeAdjust(3);
        this.setViewType(5);
        this.setMaxScale(2.0E7f);
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(this);
        this.paths = PropUtils.initPathsFromProperties(properties, prefix + DTEDPathsProperty, this.paths);
        this.setOpaqueness(PropUtils.intFromProperties(properties, prefix + OpaquenessProperty, this.getOpaqueness()));
        this.setNumColors(PropUtils.intFromProperties(properties, prefix + NumColorsProperty, this.getNumColors()));
        this.setDtedLevel(PropUtils.intFromProperties(properties, prefix + DTEDLevelProperty, this.getDtedLevel()));
        this.setViewType(PropUtils.intFromProperties(properties, prefix + DTEDViewTypeProperty, this.getViewType()));
        this.setSlopeAdjust(PropUtils.intFromProperties(properties, prefix + DTEDSlopeAdjustProperty, this.getSlopeAdjust()));
        this.setBandHeight(PropUtils.intFromProperties(properties, prefix + DTEDBandHeightProperty, this.getBandHeight()));
        this.setMaxScale(PropUtils.floatFromProperties(properties, prefix + DTEDMinScaleProperty, this.getMaxScale()));
        this.setCacheSize(PropUtils.intFromProperties(properties, prefix + DTEDFrameCacheSizeProperty, this.getCacheSize()));
        this.setKillCache(PropUtils.booleanFromProperties(properties, prefix + DTEDKillCacheProperty, this.getKillCache()));
    }

    public void removed(Container cont) {
        if (this.killCache) {
            Debug.output("DTEDLayer: emptying cache!");
            this.cache = null;
        }
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList omGraphicList;
        Projection projection = this.getProjection();
        if (projection == null) {
            Debug.error("DTED Layer needs to be added to the MapBean before it can draw images!");
            return new OMGraphicList();
        }
        DTEDCacheManager cache = this.getCache();
        if (!(projection instanceof EqualArc)) {
            // empty if block
        }
        Debug.message("basic", this.getName() + "|DTEDLayer.prepare(): doing it");
        if (Debug.debugging("dted")) {
            Debug.output(this.getName() + "|DTEDLayer.prepare(): calling getRectangle  with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        if (projection.getScale() < this.maxScale) {
            omGraphicList = cache.getRectangle(projection);
        } else {
            this.fireRequestInfoLine("  The scale is too small for DTED viewing.");
            Debug.error("DTEDLayer: scale (1:" + projection.getScale() + ") is smaller than minimum (1:" + this.maxScale + ") allowed.");
            omGraphicList = new OMGraphicList();
        }
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            Debug.message("basic", this.getName() + "|DTEDLayer.prepare(): finished with " + size + " graphics");
        } else {
            Debug.message("basic", this.getName() + "|DTEDLayer.prepare(): finished with null graphics list");
        }
        return omGraphicList;
    }

    public void paint(Graphics g) {
        Debug.message("dted", this.getName() + "|DTEDLayer.paint()");
        super.paint(g);
        if (this.location != null) {
            this.location.render(g);
        }
        this.location = null;
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int vt) {
        switch (vt) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                this.viewType = vt;
                if (this.cache == null) break;
                DTEDFrameSubframeInfo dfsi = this.cache.getSubframeInfo();
                dfsi.viewType = this.viewType;
                break;
            }
        }
    }

    public int getBandHeight() {
        return this.bandHeight;
    }

    public void setBandHeight(int bh) {
        this.bandHeight = bh;
        if (this.cache != null) {
            DTEDFrameSubframeInfo dfsi = this.cache.getSubframeInfo();
            dfsi.bandHeight = this.bandHeight;
        }
    }

    public int getSlopeAdjust() {
        return this.slopeAdjust;
    }

    public void setSlopeAdjust(int sa) {
        if (sa > 0 && sa <= 5) {
            this.slopeAdjust = sa;
            if (this.cache != null) {
                DTEDFrameSubframeInfo dfsi = this.cache.getSubframeInfo();
                dfsi.slopeAdjust = this.slopeAdjust;
            }
        } else {
            Debug.output("DTEDLayer (" + this.getName() + ") being told to set slope adjustment to invalid value (" + sa + "), must be 1-5");
        }
    }

    public int getDtedLevel() {
        return this.dtedLevel;
    }

    public void setDtedLevel(int level) {
        this.dtedLevel = level;
    }

    public int getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(int o) {
        if (o >= 0) {
            this.opaqueness = o;
            if (this.cache != null) {
                this.cache.setOpaqueness(this.opaqueness);
            }
        }
    }

    public boolean getKillCache() {
        return this.killCache;
    }

    public void setKillCache(boolean kc) {
        this.killCache = kc;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cs) {
        if (cs > 0) {
            this.cacheSize = cs;
        } else {
            Debug.output("DTEDLayer (" + this.getName() + ") being told to set cache size to invalid value (" + cs + ").");
        }
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setNumColors(int nc) {
        if (nc > 0) {
            this.numColors = nc;
            if (this.cache != null) {
                this.cache.setNumColors(this.numColors);
            }
        }
    }

    public Component getGUI() {
        if (this.paletteBox == null) {
            int selectedView;
            if (Debug.debugging("dted")) {
                Debug.output("DTEDLayer: creating DTED Palette.");
            }
            this.paletteBox = Box.createVerticalBox();
            Box subbox1 = Box.createHorizontalBox();
            Box subbox2 = Box.createVerticalBox();
            Box subbox3 = Box.createHorizontalBox();
            JPanel levelPanel = PaletteHelper.createPaletteJPanel("DTED Level");
            ButtonGroup levels = new ButtonGroup();
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DTEDLayer.this.cache != null) {
                        String ac = e.getActionCommand();
                        int newLevel = ac.equalsIgnoreCase(DTEDLayer.this.level2Command) ? 2 : (ac.equalsIgnoreCase(DTEDLayer.this.level1Command) ? 1 : 0);
                        DTEDFrameSubframeInfo dfsi = DTEDLayer.this.cache.getSubframeInfo();
                        dfsi.dtedLevel = newLevel;
                    }
                }
            };
            JRadioButton level0 = new JRadioButton("Level 0");
            level0.addActionListener(al);
            level0.setActionCommand(this.level0Command);
            JRadioButton level1 = new JRadioButton("Level 1");
            level1.addActionListener(al);
            level1.setActionCommand(this.level1Command);
            JRadioButton level2 = new JRadioButton("Level 2");
            level2.addActionListener(al);
            level2.setActionCommand(this.level2Command);
            levels.add(level0);
            levels.add(level1);
            levels.add(level2);
            switch (this.dtedLevel) {
                case 2: {
                    level2.setSelected(true);
                    break;
                }
                case 1: {
                    level1.setSelected(true);
                    break;
                }
                default: {
                    level0.setSelected(true);
                }
            }
            levelPanel.add(level0);
            levelPanel.add(level1);
            levelPanel.add(level2);
            JPanel viewPanel = PaletteHelper.createPaletteJPanel("View Type");
            String[] viewStrings = new String[]{"None", "Shading", "Elevation Shading", "Elevation Bands (Meters)", "Elevation Bands (Feet)"};
            JComboBox<String> viewList = new JComboBox<String>(viewStrings);
            viewList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox jcb = (JComboBox)e.getSource();
                    int newView = jcb.getSelectedIndex();
                    switch (newView) {
                        case 0: {
                            DTEDLayer.this.viewType = 0;
                            break;
                        }
                        case 1: {
                            DTEDLayer.this.viewType = 1;
                            break;
                        }
                        case 2: {
                            DTEDLayer.this.viewType = 5;
                            break;
                        }
                        case 3: {
                            DTEDLayer.this.viewType = 2;
                            break;
                        }
                        case 4: {
                            DTEDLayer.this.viewType = 3;
                            break;
                        }
                        default: {
                            DTEDLayer.this.viewType = 0;
                        }
                    }
                    if (DTEDLayer.this.cache != null) {
                        DTEDFrameSubframeInfo dfsi = DTEDLayer.this.cache.getSubframeInfo();
                        dfsi.viewType = DTEDLayer.this.viewType;
                    }
                }
            });
            switch (this.viewType) {
                case 0: 
                case 1: {
                    selectedView = this.viewType;
                    break;
                }
                case 2: 
                case 3: {
                    selectedView = this.viewType + 1;
                    break;
                }
                case 4: {
                    String[] viewStrings2 = new String[]{"None", "Shading", "Elevation Bands (Meters)", "Elevation Bands (Feet)", "Subframe Testing", "Elevation Shading"};
                    viewList = new JComboBox<String>(viewStrings2);
                    viewList.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            JComboBox jcb = (JComboBox)e.getSource();
                            int newView = jcb.getSelectedIndex();
                            if (DTEDLayer.this.cache != null) {
                                DTEDFrameSubframeInfo dfsi = DTEDLayer.this.cache.getSubframeInfo();
                                dfsi.viewType = newView;
                            }
                        }
                    });
                    selectedView = this.viewType;
                    break;
                }
                case 5: {
                    selectedView = 2;
                    break;
                }
                default: {
                    selectedView = 0;
                }
            }
            viewList.setSelectedIndex(selectedView);
            viewPanel.add(viewList);
            JPanel contrastPanel = PaletteHelper.createPaletteJPanel("Contrast Adjustment");
            JSlider contrastSlide = new JSlider(0, 1, 5, this.slopeAdjust);
            Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
            dict.put(new Integer(1), new JLabel("min"));
            dict.put(new Integer(5), new JLabel("max"));
            contrastSlide.setLabelTable(dict);
            contrastSlide.setPaintLabels(true);
            contrastSlide.setMajorTickSpacing(1);
            contrastSlide.setPaintTicks(true);
            contrastSlide.setSnapToTicks(true);
            contrastSlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (slider.getValueIsAdjusting()) {
                        DTEDLayer.this.fireRequestInfoLine(DTEDLayer.this.getName() + " - Contrast Slider value = " + slider.getValue());
                        DTEDLayer.this.slopeAdjust = slider.getValue();
                        if (DTEDLayer.this.cache != null) {
                            DTEDFrameSubframeInfo dfsi = DTEDLayer.this.cache.getSubframeInfo();
                            dfsi.slopeAdjust = DTEDLayer.this.slopeAdjust;
                        }
                    }
                }
            });
            contrastPanel.add(contrastSlide);
            JPanel bandPanel = PaletteHelper.createPaletteJPanel("Band Elevation Spacing");
            JSlider bandSlide = new JSlider(0, 0, 1000, this.bandHeight);
            bandSlide.setLabelTable(bandSlide.createStandardLabels(250));
            bandSlide.setPaintLabels(true);
            bandSlide.setMajorTickSpacing(250);
            bandSlide.setMinorTickSpacing(50);
            bandSlide.setPaintTicks(true);
            bandSlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (slider.getValueIsAdjusting()) {
                        DTEDLayer.this.fireRequestInfoLine(DTEDLayer.this.getName() + " - Band Slider value = " + slider.getValue());
                        DTEDLayer.this.bandHeight = slider.getValue();
                        if (DTEDLayer.this.cache != null) {
                            DTEDFrameSubframeInfo dfsi = DTEDLayer.this.cache.getSubframeInfo();
                            dfsi.bandHeight = DTEDLayer.this.bandHeight;
                        }
                    }
                }
            });
            bandPanel.add(bandSlide);
            JButton redraw = new JButton("Redraw DTED Layer");
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            subbox1.add(levelPanel);
            subbox1.add(viewPanel);
            this.paletteBox.add(subbox1);
            subbox2.add(contrastPanel);
            subbox2.add(bandPanel);
            this.paletteBox.add(subbox2);
            subbox3.add(redraw);
            this.paletteBox.add(subbox3);
        }
        return this.paletteBox;
    }

    public synchronized MapMouseInterpreter getMouseEventInterpreter() {
        if (this.getMouseModeIDsForEvents() != null && this.mouseEventInterpreter == null) {
            this.setMouseEventInterpreter(new StandardMapMouseInterpreter(this){

                public boolean leftClick(MouseEvent me) {
                    super.leftClick(me);
                    DTEDLayer.this.determineLocation(me);
                    return true;
                }

                public boolean leftClick(OMGraphic omg, MouseEvent me) {
                    super.leftClick(omg, me);
                    DTEDLayer.this.determineLocation(me);
                    return true;
                }
            });
        }
        return this.mouseEventInterpreter;
    }

    public boolean determineLocation(MouseEvent e) {
        Projection projection = this.getProjection();
        if (this.cache != null && projection != null) {
            LatLonPoint ll = projection.inverse(e.getX(), e.getY(), new LatLonPoint.Double());
            this.location = new DTEDLocation(e.getX(), e.getY());
            this.location.setElevation(this.cache.getElevation((float)ll.getY(), (float)ll.getX()));
            this.location.generate(projection);
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean isHighlightable(OMGraphic omg) {
        return false;
    }

    static class DTEDLocation {
        OMText text;
        OMRect dot;

        public DTEDLocation(int x, int y) {
            this.text = new OMText(x + 10, y, (String)null, (Font)null, 0);
            this.dot = new OMRect(x - 1, y - 1, x + 1, y + 1);
            this.text.setLinePaint(Color.red);
            this.dot.setLinePaint(Color.red);
        }

        public void setElevation(int elevation) {
            if (elevation < -100) {
                this.text.setData("No Data Here");
            } else {
                int elevation_ft = (int)((float)elevation * 3.28084f);
                this.text.setData(elevation + " m / " + elevation_ft + " ft");
            }
        }

        public void setLocation(int x, int y) {
            this.text.setX(x + 10);
            this.text.setY(y);
            this.dot.setLocation(x - 1, y - 1, x + 1, y + 1);
        }

        public void render(Graphics g) {
            this.text.render(g);
            this.dot.render(g);
        }

        public void generate(Projection proj) {
            this.text.generate(proj);
            this.dot.generate(proj);
        }
    }
}

