/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CacheLayer
extends Layer
implements ActionListener,
MapMouseListener {
    public static final String CacheFileProperty = "cacheFile";
    private static final String READ_DATA_COMMAND = "ReadData";
    protected URL cacheURL;
    protected OMGraphicList omgraphics = new OMGraphicList();
    private OMGraphic selectedGraphic;
    private Color oldFillColor = Color.yellow;

    public void readGraphics() throws IOException {
        if (Debug.debugging("cachelayer")) {
            Debug.output("Reading cached graphics");
        }
        if (this.omgraphics == null) {
            this.omgraphics = new OMGraphicList();
        }
        if (this.cacheURL != null) {
            this.omgraphics.readGraphics(this.cacheURL);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String cacheFile = props.getProperty(prefix + CacheFileProperty);
        try {
            if (cacheFile != null) {
                if (Debug.debugging("cachelayer")) {
                    Debug.output("Getting cachefile: " + cacheFile);
                }
                this.cacheURL = PropUtils.getResourceOrFileOrURL(this, cacheFile);
                if (this.cacheURL != null) {
                    this.readGraphics();
                }
            }
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        this.omgraphics.render(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        this.omgraphics.project(e.getProjection(), true);
        this.repaint();
    }

    public Component getGUI() {
        JButton rereadFilesButton = new JButton("ReRead OMGraphics");
        rereadFilesButton.setActionCommand(READ_DATA_COMMAND);
        rereadFilesButton.addActionListener(this);
        JLabel fileLabel = new JLabel("Read from: ");
        JTextField pathText = new JTextField(this.cacheURL.toString());
        Box filebox = Box.createHorizontalBox();
        filebox.add(fileLabel);
        filebox.add(pathText);
        Box box = Box.createVerticalBox();
        box.add(rereadFilesButton);
        box.add(filebox);
        return box;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == READ_DATA_COMMAND) {
            Debug.message("cachelayer", "CacheLayer: Reading serialized graphics");
            try {
                this.readGraphics();
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        } else {
            Debug.error("Unknown action command \"" + cmd + "\" in SaveShapeLayer.actionPerformed().");
        }
    }

    public String[] getMouseModeServiceList() {
        String[] ret = new String[]{"Gestures"};
        return ret;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.selectedGraphic != null) {
            switch (e.getClickCount()) {
                case 1: {
                    if (!Debug.debugging("cachelayer")) break;
                    Debug.output("CacheLayer: Show Info: " + this.selectedGraphic.getAttribute("Information Line"));
                    break;
                }
                case 2: {
                    if (!Debug.debugging("cachelayer")) break;
                    Debug.output("CacheLayer: Request URL: " + this.selectedGraphic);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        OMGraphic newSelectedGraphic = (OMGraphic)this.omgraphics.selectClosest(e.getX(), e.getY(), 2.0f);
        if (newSelectedGraphic != this.selectedGraphic) {
            if (this.selectedGraphic != null) {
                this.selectedGraphic.setFillPaint(this.oldFillColor);
            }
            this.selectedGraphic = newSelectedGraphic;
            if (newSelectedGraphic != null) {
                this.oldFillColor = newSelectedGraphic.getFillColor();
                newSelectedGraphic.setFillPaint(Color.white);
                this.fireRequestInfoLine(newSelectedGraphic.getAttribute("Information Line").toString());
            }
            this.repaint();
        }
        return true;
    }

    public void mouseMoved() {
        this.omgraphics.deselect();
        this.repaint();
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }
}

