/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.ImageHelper;
import com.bbn.openmap.util.ComponentFactory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class BufferedImageHelper {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.io.BufferedImageHelper");
    private static Object jaiObj = null;
    private static boolean checkedForJAI = false;

    private BufferedImageHelper() {
    }

    protected static Object getJAI() {
        if (!checkedForJAI) {
            jaiObj = ComponentFactory.create("javax.media.jai.JAI");
            checkedForJAI = true;
        }
        return jaiObj;
    }

    public static BufferedImage getJAIBufferedImage(String opName, Object param) {
        block15: {
            boolean DEBUG = logger.isLoggable(Level.FINE);
            Object jai = BufferedImageHelper.getJAI();
            if (jai == null) {
                return null;
            }
            if (DEBUG) {
                logger.fine("Using JAI to create image from " + opName);
            }
            try {
                Class[] createArgs = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Object")};
                Method createMethod = jai.getClass().getDeclaredMethod("create", createArgs);
                Object[] createParams = new Object[]{opName, param};
                Object planarImageObject = createMethod.invoke(jai, createParams);
                if (planarImageObject != null) {
                    Method getBufferedImageMethod = planarImageObject.getClass().getMethod("getAsBufferedImage", null);
                    return (BufferedImage)getBufferedImageMethod.invoke(planarImageObject, (Object[])null);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (DEBUG) {
                    logger.warning("BufferedImageHelper.getJAIBufferedImage() ClassNotFoundException error: \n" + cnfe.getMessage());
                }
            }
            catch (IllegalAccessException iae) {
                if (DEBUG) {
                    logger.warning("BufferedImageHelper.getJAIBufferedImage() IllegalAccessException error: \n" + iae.getMessage());
                }
            }
            catch (InvocationTargetException ite) {
                if (DEBUG) {
                    logger.warning("BufferedImageHelper.getJAIBufferedImage() InvocationTargetException error: \n" + ite.getMessage());
                }
            }
            catch (NoSuchMethodException nsme) {
                if (DEBUG) {
                    logger.warning("BufferedImageHelper.getJAIBufferedImage() NoSuchMethodException error: " + nsme.toString());
                    nsme.printStackTrace();
                }
            }
            catch (SecurityException se) {
                if (DEBUG) {
                    logger.warning("BufferedImageHelper.getJAIBufferedImage() SecurityException error: \n" + se.getMessage());
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block15;
                logger.warning("BufferedImageHelper.getJAIBufferedImage() Exception: \n" + e.getMessage());
            }
        }
        return null;
    }

    public static BufferedImage getJAIBufferedImage(String opName, Object param, int x, int y, int w, int h) throws InterruptedException {
        BufferedImage bi = BufferedImageHelper.getJAIBufferedImage(opName, param);
        if (bi != null && (x != 0 || y != 0 || w > 0 || h > 0)) {
            int imageType = 1;
            if (bi.getColorModel().hasAlpha()) {
                imageType = 2;
            }
            return BufferedImageHelper.getBufferedImage(bi, x, y, w, h, imageType);
        }
        return bi;
    }

    public static BufferedImage getBufferedImage(URL url) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(url, 0, 0, -1, -1);
    }

    public static BufferedImage getBufferedImage(URL url, int x, int y, int w, int h) throws InterruptedException {
        if (url == null) {
            return null;
        }
        BufferedImage bi = BufferedImageHelper.getJAIBufferedImage("url", url, x, y, w, h);
        if (bi != null) {
            return bi;
        }
        logger.fine("BufferedImageHelper.getBufferedImage(URL) can't use JAI, using ImageIcon");
        ImageIcon ii = new ImageIcon(url);
        String path = url.getPath();
        boolean noAlpha = path.endsWith("jpg") || path.endsWith("jpeg");
        BufferedImage bufferedImage = BufferedImageHelper.getBufferedImage(ii, x, y, w, h, !noAlpha);
        ii.getImage().flush();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(ImageIcon ii, int x, int y, int w, int h, boolean hasAlpha) throws InterruptedException {
        if (w <= 0) {
            w = ii.getIconWidth();
        }
        if (h <= 0) {
            h = ii.getIconHeight();
        }
        return BufferedImageHelper.getBufferedImage(ii.getImage(), x, y, w, h, hasAlpha ? 2 : 1);
    }

    public static BufferedImage getBufferedImage(String path) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(path, 0, 0, -1, -1);
    }

    public static BufferedImage getBufferedImage(String path, int x, int y, int w, int h) throws InterruptedException {
        BufferedImage bi = BufferedImageHelper.getJAIBufferedImage("file", path, x, y, w, h);
        if (bi != null) {
            return bi;
        }
        logger.fine("BufferedImageHelper.getBufferedImage(path) can't use JAI, using ImageIcon");
        ImageIcon ii = new ImageIcon(path);
        boolean noAlpha = path.endsWith("jpg") || path.endsWith("jpeg");
        return BufferedImageHelper.getBufferedImage(ii, x, y, w, h, !noAlpha);
    }

    public static BufferedImage getBufferedImage(Image image, int x, int y, int w, int h) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(image, x, y, w, h, 1);
    }

    public static BufferedImage getBufferedImage(Image image, int x, int y, int w, int h, int imageType) throws InterruptedException {
        if (w <= 0 || h <= 0) {
            logger.fine("BufferedImageHelper.getBufferedImage() don't know h/w, using pixel grabber");
            return BufferedImageHelper.getBufferedImageFromPixelGrabber(image, x, y, w, h, imageType);
        }
        BufferedImage bufferedImage = new BufferedImage(w, h, imageType);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, x, y, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImageFromPixelGrabber(Image image, int x, int y, int w, int h, int imageType) {
        PixelGrabber pg = new PixelGrabber(image, x, y, w, h, true);
        int[] pixels = ImageHelper.grabPixels(pg);
        if (pixels == null) {
            return null;
        }
        w = pg.getWidth();
        h = pg.getHeight();
        pg = null;
        BufferedImage bi = new BufferedImage(w, h, imageType);
        logger.fine("BufferedImageHelper.getBufferedImage(): Got buffered image...");
        WritableRaster raster = bi.getRaster();
        raster.setDataElements(0, 0, w, h, pixels);
        logger.fine("BufferedImageHelper.getBufferedImage(): set pixels in image...");
        return bi;
    }
}

