/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.ShpFileEmptyTileHandler;
import com.bbn.openmap.dataAccess.mapTile.SimpleEmptyTileHandler;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.ClasspathHacker;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;

public class WholeWorldTileHandler
extends ShpFileEmptyTileHandler {
    public static final String SUBJAR_ZOOMLEVEL_PROPERTY = "subJarZoomLevel";
    public static final String WORLDWIDE_ZOOMLEVEL_PROPERTY = "worldWideZoomLevel";
    public static final String PARENT_JAR_NAME_PROPERTY = "parentJarName";
    public static final int DEFAULT_SUBJAR_DEF_ZOOMLEVEL = 3;
    public static final int DEFAULT_WORLDWIDE_ZOOMLEVEL = 10;
    protected int subFrameDefZoomLevel = 3;
    protected int worldWideZoomLevel = 10;
    protected String parentJarName;
    protected Set<String> loadedJars = Collections.synchronizedSet(new HashSet());
    protected String rootDirForJars;
    static final String SOURCE = "source";
    static final String TARGET = "target";
    static final String SUB_JAR_ZOOM = "subJarZoom";
    static final String MAX_ZOOM_IN_SUBJARS = "maxZoomInSubJars";
    static final String WORLD_WIDE_ZOOM_LEVEL = "worldWideZoomLevel";
    static final String TILE_EXT = "tileExt";
    static final String MINX = "minx";
    static final String MINY = "miny";
    static final String MAXX = "maxx";
    static final String MAXY = "maxy";
    static final String NO_WORLD_JAR = "noWorldJar";
    static final String VERBOSE = "verbose";
    static final String FILL = "fill";
    public static final int WIN_MAX_FILES_IN_JAR = 262144;

    /*
     * Unable to fully structure code
     */
    public BufferedImage getImageForEmptyTile(String imagePath, int x, int y, int zoomLevel, MapTileCoordinateTransform mtcTransform, Projection proj) {
        bi = null;
        if (this.parentJarName != null) {
            pnt = new Point2D.Double(x, y);
            tileUL = mtcTransform.tileUVToLatLon(pnt, zoomLevel);
            jarFilePath = new StringBuilder("jar:file:").append(this.rootDirForJars).append("/");
            if (zoomLevel <= this.worldWideZoomLevel) {
                jarFilePath.append(this.parentJarName);
            } else {
                subframeUVPnt = mtcTransform.latLonToTileUV(tileUL, this.subFrameDefZoomLevel);
                jarFilePath.append(WholeWorldTileHandler.buildSubJarName(this.parentJarName, subframeUVPnt.getX(), subframeUVPnt.getY()));
            }
            jarFilePath.append("!/").append(imagePath);
            imageBytes = this.getImageBytes(jarFilePath.toString());
            if (imageBytes != null && imageBytes.length > 0) {
                try {
                    ii = new ImageIcon(imageBytes);
                    origImage = ii.getImage();
                    imageWidth = ii.getIconWidth();
                    imageHeight = ii.getIconHeight();
                    if (origImage instanceof BufferedImage) {
                        return (BufferedImage)origImage;
                    }
                    return BufferedImageHelper.getBufferedImage(origImage, 0, 0, imageWidth, imageHeight, 2);
                }
                catch (InterruptedException ie) {
                    if (!WholeWorldTileHandler.logger.isLoggable(Level.FINE)) ** GOTO lbl30
                    WholeWorldTileHandler.logger.fine("WholeWorldTileHandler interrupted fetching " + imagePath);
                }
            }
        } else {
            WholeWorldTileHandler.logger.fine("parent jar name not set, can't figure out how to load tile jars.");
        }
lbl30:
        // 3 sources

        if (bi == null) {
            bi = super.getImageForEmptyTile(imagePath, x, y, zoomLevel, mtcTransform, proj);
        }
        return bi;
    }

    public static String buildSubJarName(String parentJarNme, double x, double y) {
        int dotIndex = parentJarNme.length();
        if (parentJarNme.endsWith(".jar")) {
            dotIndex = parentJarNme.lastIndexOf(46);
        }
        StringBuilder sBuilder = new StringBuilder(parentJarNme.substring(0, dotIndex));
        sBuilder.append("_" + (int)x + "_" + (int)y + parentJarNme.substring(dotIndex));
        return sBuilder.toString();
    }

    public byte[] getImageBytes(String imagePath) {
        byte[] imageBytes = null;
        try {
            URL url = new URL(imagePath);
            URLConnection urlc = url.openConnection();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("url content type: " + urlc.getContentType());
            }
            if (urlc == null || urlc.getContentType() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("unable to connect to (tile might be unavailable): " + imagePath);
                }
            } else if (urlc.getContentType().startsWith("text")) {
                String st;
                BufferedReader bin = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                StringBuffer message = new StringBuffer();
                while ((st = bin.readLine()) != null) {
                    message.append(st);
                }
                logger.fine(message.toString());
            } else if (urlc.getContentType().startsWith("image")) {
                InputStream in = urlc.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int buflen = 2048;
                byte[] buf = new byte[buflen];
                int len = -1;
                while ((len = in.read(buf, 0, buflen)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
                out.close();
                imageBytes = out.toByteArray();
            }
        }
        catch (MalformedURLException murle) {
            logger.warning("WholeWorldTileHandler: URL \"" + imagePath + "\" is malformed.");
        }
        catch (IOException ioe) {
            logger.fine("Couldn't connect to " + imagePath + ", connection problem");
        }
        return imageBytes;
    }

    protected synchronized boolean loadJar(String jarFileName) {
        boolean ret = this.loadedJars.contains(jarFileName);
        if (!ret) {
            try {
                logger.fine("adding " + jarFileName + " to classpath");
                ClasspathHacker.addFile(jarFileName);
            }
            catch (IOException ioe) {
                logger.warning("couldn't add map data jar file: " + jarFileName);
            }
            this.loadedJars.add(jarFileName);
        }
        return !ret;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.subFrameDefZoomLevel = PropUtils.intFromProperties(props, prefix + SUBJAR_ZOOMLEVEL_PROPERTY, this.subFrameDefZoomLevel);
        this.worldWideZoomLevel = PropUtils.intFromProperties(props, prefix + "worldWideZoomLevel", this.worldWideZoomLevel);
        this.rootDirForJars = props.getProperty(prefix + "rootDirPath", this.rootDirForJars);
        String jarBaseName = props.getProperty(prefix + PARENT_JAR_NAME_PROPERTY);
        if (jarBaseName != null) {
            this.setParentJarName(jarBaseName);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + SUBJAR_ZOOMLEVEL_PROPERTY, Integer.toString(this.subFrameDefZoomLevel));
        props.put(prefix + "worldWideZoomLevel", Integer.toString(this.worldWideZoomLevel));
        props.put(prefix + PARENT_JAR_NAME_PROPERTY, PropUtils.unnull(this.getParentJarName()));
        return props;
    }

    public int getSubFrameDefZoomLevel() {
        return this.subFrameDefZoomLevel;
    }

    public void setSubFrameDefZoomLevel(int subFrameZoomLevel) {
        this.subFrameDefZoomLevel = subFrameZoomLevel;
    }

    public String getParentJarName() {
        return this.parentJarName;
    }

    public void setParentJarName(String parentJarName) {
        this.parentJarName = parentJarName;
    }

    public int getWorldWideZoomLevel() {
        return this.worldWideZoomLevel;
    }

    public void setWorldWideZoomLevel(int worldWideZoomLevel) {
        this.worldWideZoomLevel = worldWideZoomLevel;
    }

    public static void main(String[] args) {
        String[] arg;
        ArgParser ap = new ArgParser("WholeWorldTileHandler");
        ap.add(SOURCE, "Path to the tile root directory.", 1);
        ap.add(TARGET, "Path to the tile root directory for the jarred tile files.", 1);
        ap.add(SUB_JAR_ZOOM, "Zoom level tiles that subjar boundaries are based on (3 is default).", 1);
        ap.add(MAX_ZOOM_IN_SUBJARS, "Maximum tile zoom level added to sub jars (20 is default).", 1);
        ap.add("worldWideZoomLevel", "Maximum tile zoom level to add to world wide jar (10 is default).", 1);
        ap.add(TILE_EXT, "Tile extension (.png is default).", 1);
        ap.add(MINX, "Subjar x minimum to create", 1);
        ap.add(MINY, "Subjar y minimum to create", 1);
        ap.add(MAXX, "Subjar x maximum to create", 1);
        ap.add(MAXY, "Subjar y maximum to create", 1);
        ap.add(NO_WORLD_JAR, "Don't create world level jar file");
        ap.add(VERBOSE, "Comment on what's going on");
        ap.add(FILL, "Just create jars that don't exist.");
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        if ((arg = ap.getArgValues(SOURCE)) != null) {
            try {
                Builder wwthBuilder = new Builder(new File(arg[0]));
                arg = ap.getArgValues(TARGET);
                if (arg != null) {
                    wwthBuilder.targetFile(new File(arg[0]));
                }
                if ((arg = ap.getArgValues(SUB_JAR_ZOOM)) != null) {
                    wwthBuilder.subJarZoomDef(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues(MAX_ZOOM_IN_SUBJARS)) != null) {
                    wwthBuilder.maxZoomLevelInSubJars(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues("worldWideZoomLevel")) != null) {
                    wwthBuilder.worldWideZoomLevel(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues(TILE_EXT)) != null) {
                    wwthBuilder.tileExt(arg[0]);
                }
                if ((arg = ap.getArgValues(MINX)) != null) {
                    wwthBuilder.minx(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues(MINY)) != null) {
                    wwthBuilder.miny(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues(MAXX)) != null) {
                    wwthBuilder.maxx(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues(MAXY)) != null) {
                    wwthBuilder.maxy(Integer.parseInt(arg[0]));
                }
                if ((arg = ap.getArgValues(VERBOSE)) != null) {
                    wwthBuilder.logLevel = Level.INFO;
                }
                if ((arg = ap.getArgValues(FILL)) != null) {
                    wwthBuilder.setFill(true);
                }
                if ((arg = ap.getArgValues(NO_WORLD_JAR)) != null) {
                    logger.log(wwthBuilder.logLevel, "setting build world file to false");
                    wwthBuilder.setDoWorldJar(false);
                }
                System.out.println(wwthBuilder.toString());
                wwthBuilder.go();
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                logger.warning(nfe.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                logger.warning(fnfe.getMessage());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                logger.warning(ioe.getMessage());
            }
        } else {
            ap.bail("Need a source directory.", true);
        }
        System.exit(0);
    }

    public static class Builder {
        protected File sourceFile;
        protected File targetFile;
        protected int subJarZoomDef = 3;
        protected int worldWideZoomLevel = 10;
        protected int maxZoomLevelInSubJars = 20;
        protected String tileExt = ".png";
        protected int minx = 0;
        protected int miny = 0;
        protected int maxx = -1;
        protected int maxy = -1;
        protected boolean doWorldJar = true;
        protected boolean fill = false;
        protected Level logLevel = Level.FINE;

        public Builder(File source) throws FileNotFoundException {
            if (source == null || !source.exists()) {
                throw new FileNotFoundException("Source file invalid");
            }
            this.sourceFile = source;
        }

        public Builder targetFile(File targetFile) {
            this.targetFile = targetFile;
            return this;
        }

        public Builder tileExt(String tileExtension) {
            if (!tileExtension.startsWith(".")) {
                tileExtension = "." + tileExtension;
            }
            this.tileExt = tileExtension;
            return this;
        }

        public Builder subJarZoomDef(int zoomLevel) throws NumberFormatException {
            if (this.checkZoomLevel(zoomLevel)) {
                this.subJarZoomDef = zoomLevel;
            }
            return this;
        }

        public Builder worldWideZoomLevel(int zoomLevel) throws NumberFormatException {
            if (this.checkZoomLevel(zoomLevel)) {
                this.worldWideZoomLevel = zoomLevel;
            }
            return this;
        }

        public Builder maxZoomLevelInSubJars(int zoomLevel) throws NumberFormatException {
            if (this.checkZoomLevel(zoomLevel)) {
                this.maxZoomLevelInSubJars = zoomLevel;
            }
            return this;
        }

        protected boolean checkZoomLevel(int zoomLevel) {
            if (zoomLevel < 0 || zoomLevel > 20) {
                throw new NumberFormatException("Zoom level needs to be > 0 and < 20");
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("WholeWorldTileHandler[");
            sb.append("source:").append(this.sourceFile).append(',');
            sb.append("target:").append(this.targetFile).append(',');
            sb.append("subJarZoomDef:").append(this.subJarZoomDef).append(',');
            sb.append("worldWideZoomLevel:").append(this.worldWideZoomLevel).append(',');
            sb.append("maxZoomLevelInSubJars:").append(this.maxZoomLevelInSubJars).append(',');
            sb.append("tileExt:").append(this.tileExt);
            if (this.minx != 0) {
                sb.append(",").append("minx:").append(this.minx);
            }
            if (this.miny != 0) {
                sb.append(",").append("miny:").append(this.miny);
            }
            if (this.maxx >= 0) {
                sb.append(",").append("maxx:").append(this.maxx);
            }
            if (this.maxy >= 0) {
                sb.append(",").append("maxy:").append(this.maxy);
            }
            sb.append(']');
            return sb.toString();
        }

        protected void copyAndUpdateProperties(File sourceDir, File targetDir) {
            File propertiesFile = new File(sourceDir, "tiles.omp");
            if (propertiesFile.exists()) {
                try {
                    URL propertiesURL = propertiesFile.toURI().toURL();
                    Properties props = new Properties();
                    props.load(propertiesURL.openStream());
                    props.put("emptyTileHandler", WholeWorldTileHandler.class.getName());
                    props.put(WholeWorldTileHandler.SUBJAR_ZOOMLEVEL_PROPERTY, Integer.toString(this.subJarZoomDef));
                    props.put("worldWideZoomLevel", Integer.toString(this.worldWideZoomLevel));
                    props.put(WholeWorldTileHandler.PARENT_JAR_NAME_PROPERTY, sourceDir.getName() + ".jar");
                    props.put("rootDir", sourceDir.getName());
                    FileOutputStream fos = new FileOutputStream(new File(targetDir, "tiles.omp"));
                    props.store(fos, "Properties for " + targetDir + " tile set");
                    fos.close();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    SimpleEmptyTileHandler.logger.warning("can't find/read properties file for tile set");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    SimpleEmptyTileHandler.logger.warning("exception reading/copying properties file for tile set");
                }
            }
        }

        public void go() throws FileNotFoundException, IOException {
            if (this.targetFile == null) {
                this.targetFile = new File(this.sourceFile, this.sourceFile.getName());
            }
            if (!this.targetFile.exists()) {
                this.targetFile.mkdirs();
            }
            File parentOfSourceFile = this.sourceFile.getParentFile();
            int numCharsTrimmedOffNameInZip = 0;
            if (parentOfSourceFile != null) {
                numCharsTrimmedOffNameInZip = parentOfSourceFile.getAbsolutePath().length() + 1;
            }
            SimpleEmptyTileHandler.logger.log(Level.INFO, "inspecting files in " + this.sourceFile + " (" + (parentOfSourceFile == null ? "CAUTION: nothing" : parentOfSourceFile.getAbsolutePath()) + " removed from names in jars).");
            this.copyAndUpdateProperties(this.sourceFile, this.targetFile);
            if (this.doWorldJar) {
                ArrayList<File> jarDirs = new ArrayList<File>();
                for (int zoomLevel = 0; zoomLevel <= this.worldWideZoomLevel; ++zoomLevel) {
                    File zoomLevelDir = new File(this.sourceFile, Integer.toString(zoomLevel));
                    if (!zoomLevelDir.exists()) continue;
                    jarDirs.add(zoomLevelDir);
                }
                if (!jarDirs.isEmpty() && this.sourceFile != null) {
                    File fileCheck;
                    String worldWideJarFile = this.targetFile + File.separator + this.sourceFile.getName() + ".jar";
                    SimpleEmptyTileHandler.logger.log(this.logLevel, "writing :" + worldWideJarFile);
                    if (this.fill && (fileCheck = new File(worldWideJarFile)).exists()) {
                        this.doWorldJar = false;
                    }
                    if (this.doWorldJar) {
                        FileOutputStream fos = new FileOutputStream(worldWideJarFile);
                        CheckedOutputStream checksum = new CheckedOutputStream(fos, new Adler32());
                        ZipOutputStream zoStream = new ZipOutputStream(new BufferedOutputStream(checksum));
                        for (File file : jarDirs) {
                            FileUtils.writeZipEntry(file, zoStream, numCharsTrimmedOffNameInZip);
                        }
                        zoStream.close();
                    } else {
                        SimpleEmptyTileHandler.logger.log(this.logLevel, worldWideJarFile + " already exists, skipping");
                    }
                }
            } else {
                SimpleEmptyTileHandler.logger.log(this.logLevel, "skipping world file");
            }
            int dimensionForZoom = (int)Math.pow(2.0, this.subJarZoomDef);
            OSMMapTileCoordinateTransform transform = new OSMMapTileCoordinateTransform();
            int startx = 0;
            int starty = 0;
            int endx = dimensionForZoom;
            int endy = dimensionForZoom;
            if (this.minx >= 0) {
                startx = this.minx;
            }
            if (this.maxx >= 0) {
                endx = Math.min(this.maxx + 1, dimensionForZoom);
            }
            if (this.miny >= 0) {
                starty = this.miny;
            }
            if (this.maxy >= 0) {
                endy = Math.min(this.maxy + 1, dimensionForZoom);
            }
            for (int x = startx; x < endx; ++x) {
                for (int y = starty; y < endy; ++y) {
                    Point2D llp1 = transform.tileUVToLatLon(new Point2D.Double(x, y), this.subJarZoomDef);
                    Point2D llp2 = transform.tileUVToLatLon(new Point2D.Double(x + 1, y + 2), this.subJarZoomDef);
                    File subJarFile = new File(this.targetFile, this.sourceFile.getName() + "_" + x + "_" + y + ".jar");
                    if (this.fill && subJarFile.exists()) {
                        SimpleEmptyTileHandler.logger.log(this.logLevel, subJarFile + " already exists, skipping");
                        continue;
                    }
                    SimpleEmptyTileHandler.logger.log(this.logLevel, "Creating: " + subJarFile);
                    long fileCount = 0L;
                    ZipOutputStream zoStream = null;
                    for (int zoomLevel = this.worldWideZoomLevel + 1; zoomLevel <= this.maxZoomLevelInSubJars; ++zoomLevel) {
                        File checkZoomLevelDir = new File(this.sourceFile, Integer.toString(zoomLevel));
                        if (!checkZoomLevelDir.exists()) continue;
                        Point2D uv1 = transform.latLonToTileUV(llp1, zoomLevel);
                        Point2D uv2 = transform.latLonToTileUV(llp2, zoomLevel);
                        SimpleEmptyTileHandler.logger.log(this.logLevel, "adding zoom level " + zoomLevel + " tiles to " + subJarFile.getName() + ": " + uv1 + "|" + uv2);
                        int u = (int)uv1.getX();
                        while ((double)u < uv2.getX()) {
                            int v = (int)uv1.getY();
                            while ((double)v < uv2.getY()) {
                                File tile = new File(this.sourceFile, zoomLevel + "/" + u + "/" + v + this.tileExt);
                                if (tile.exists()) {
                                    if (zoStream == null) {
                                        FileOutputStream fos = new FileOutputStream(subJarFile);
                                        CheckedOutputStream checksum = new CheckedOutputStream(fos, new Adler32());
                                        zoStream = new ZipOutputStream(new BufferedOutputStream(checksum));
                                    }
                                    if (tile.getAbsolutePath().length() - numCharsTrimmedOffNameInZip > 0) {
                                        FileUtils.writeZipEntry(tile, zoStream, numCharsTrimmedOffNameInZip);
                                        ++fileCount;
                                    } else {
                                        SimpleEmptyTileHandler.logger.info("Problem, there's something wrong with tile name: " + tile.getAbsolutePath());
                                    }
                                }
                                ++v;
                            }
                            ++u;
                        }
                    }
                    if (zoStream == null) continue;
                    zoStream.close();
                    zoStream = null;
                    SimpleEmptyTileHandler.logger.log(this.logLevel, "closing zip file (" + subJarFile.getPath() + "), added " + fileCount + " files to jar");
                }
            }
        }

        public void minx(int parseInt) {
            this.minx = parseInt;
        }

        public void miny(int parseInt) {
            this.miny = parseInt;
        }

        public void maxx(int parseInt) {
            this.maxx = parseInt;
        }

        public void maxy(int parseInt) {
            this.maxy = parseInt;
        }

        public void setDoWorldJar(boolean dwj) {
            this.doWorldJar = dwj;
        }

        public boolean isFill() {
            return this.fill;
        }

        public void setFill(boolean fill) {
            this.fill = fill;
        }
    }
}

