/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.dataAccess.dted.DTEDNameTranslator;
import com.bbn.openmap.dataAccess.dted.StandardDTEDNameTranslator;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTEDLocator
extends Wanderer
implements WandererCallback {
    static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.dted.DTEDLocator");
    boolean DEBUG = false;
    protected DTEDNameTranslator translator;
    protected LinkedList filenames = new LinkedList();
    protected File[][][] files = null;
    protected int numLevels = 3;

    public DTEDLocator() {
        if (logger.isLoggable(Level.FINE)) {
            this.DEBUG = true;
        }
        this.setCallback(this);
    }

    public DTEDLocator(String directory) {
        this(new File(directory));
    }

    public DTEDLocator(File dtedDir) {
        this();
        this.handleEntry(dtedDir);
    }

    protected void initFileHolder() {
        this.files = new File[this.numLevels][180][360];
    }

    public boolean handleDirectory(File directory) {
        if (this.DEBUG) {
            logger.fine("skipping: " + directory.getAbsolutePath());
        }
        return true;
    }

    public boolean handleFile(File file) {
        if (this.DEBUG) {
            logger.fine("searching finds: " + file.getAbsolutePath());
        }
        this.filenames.add(file);
        return true;
    }

    public DTEDNameTranslator getTranslator() {
        if (this.translator == null) {
            this.translator = new StandardDTEDNameTranslator();
        }
        return this.translator;
    }

    public void setTranslator(DTEDNameTranslator dnt) {
        this.translator = dnt;
    }

    public void organize() {
        if (this.DEBUG) {
            logger.fine("organizing frames...");
        }
        this.initFileHolder();
        Iterator it = this.filenames.iterator();
        DTEDNameTranslator dnt = this.getTranslator();
        while (it.hasNext()) {
            File file = (File)it.next();
            String filename = file.getAbsolutePath();
            try {
                dnt.set(filename);
                int l = dnt.getLevel();
                int lt = (int)(dnt.getLat() + 90.0);
                int ln = (int)(dnt.getLon() + 180.0);
                if (this.DEBUG) {
                    logger.fine("  placing " + filename + " at files[" + l + "][" + lt + "][" + ln + "]");
                }
                this.files[l][lt][ln] = file;
            }
            catch (FormatException fe) {
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {}
        }
    }

    public File get(float lat, float lon, int level) {
        try {
            return this.files[level][(int)(lat + 90.0f)][(int)(lon + 180.0f)];
        }
        catch (NullPointerException npe) {
            this.organize();
            return this.get(lat, lon, level);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static void main(String[] argv) {
        ArgParser ap = new ArgParser("DTEDLocator");
        if (argv.length == 0) {
            ap.bail("", true);
        }
        DTEDLocator locator = new DTEDLocator();
        for (int i = 0; i < argv.length; ++i) {
            locator.handleEntry(new File(argv[i]));
        }
    }
}

