/*
 * Decompiled with CFR 0.152.
 */
package registry;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import registry.LanguagePackItem;
import registry.LanguagePackParser;

public class LanguagePackRegistry {
    private static final String REGISTRY_FILE_NAME = "language-pack-registry.txt";
    private static ArrayList<LanguagePackItem> langPackRegistry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initRegistry() {
        BufferedReader regBufReader = null;
        try {
            String strLine;
            regBufReader = new BufferedReader(new FileReader(REGISTRY_FILE_NAME));
            langPackRegistry = new ArrayList();
            String packagePrefix = "";
            ArrayList<String> strArray = new ArrayList<String>();
            while ((strLine = regBufReader.readLine()) != null) {
                if (strLine.startsWith("%%")) {
                    if (!strArray.isEmpty()) {
                        langPackRegistry = LanguagePackParser.parse(packagePrefix, strArray);
                    }
                    if ((strLine = regBufReader.readLine()) != null && strLine.contains("[") && strLine.contains("]")) {
                        packagePrefix = strLine.substring(1, strLine.length() - 1);
                    }
                    strArray = new ArrayList();
                    continue;
                }
                strArray.add(strLine);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (regBufReader != null) {
                try {
                    regBufReader.close();
                }
                catch (Exception ignore) {}
            }
        }
        Collections.sort(langPackRegistry, new Comparator<LanguagePackItem>(){

            @Override
            public int compare(LanguagePackItem lpi1, LanguagePackItem lpi2) {
                return lpi1.getPackageLanguage().compareToIgnoreCase(lpi2.getPackageLanguage());
            }
        });
    }

    public static ArrayList<LanguagePackItem> getRegistry() {
        if (langPackRegistry == null) {
            LanguagePackRegistry.initRegistry();
        }
        return langPackRegistry;
    }
}

