/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XFlatParagraph;
import com.sun.star.text.XFlatParagraphIterator;
import com.sun.star.text.XFlatParagraphIteratorProvider;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.openoffice.Main;
import org.languagetool.tools.Tools;

public class LOFlatParagraph {
    private XFlatParagraphIterator xFlatParaIter = null;
    private XFlatParagraph xFlatPara = null;

    LOFlatParagraph(XComponentContext xContext) throws Exception {
        this.xFlatParaIter = LOFlatParagraph.getXFlatParagraphIterator(xContext);
        this.xFlatPara = LOFlatParagraph.getFlatParagraph(this.xFlatParaIter);
    }

    @Nullable
    private static XDesktop getCurrentDesktop(XComponentContext xContext) throws Exception {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                return null;
            }
            Object desktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            if (desktop == null) {
                return null;
            }
            return (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return null;
        }
    }

    @Nullable
    private static XComponent getCurrentComponent(XComponentContext xContext) throws Exception {
        try {
            XDesktop xdesktop = LOFlatParagraph.getCurrentDesktop(xContext);
            if (xdesktop == null) {
                return null;
            }
            return xdesktop.getCurrentComponent();
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return null;
        }
    }

    @Nullable
    private static XFlatParagraphIterator getXFlatParagraphIterator(XComponentContext xContext) throws Exception {
        try {
            XComponent xCurrentComponent = LOFlatParagraph.getCurrentComponent(xContext);
            if (xCurrentComponent == null) {
                return null;
            }
            XFlatParagraphIteratorProvider xFlatParaItPro = (XFlatParagraphIteratorProvider)UnoRuntime.queryInterface(XFlatParagraphIteratorProvider.class, (Object)xCurrentComponent);
            if (xFlatParaItPro == null) {
                return null;
            }
            return xFlatParaItPro.getFlatParagraphIterator(2, true);
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return null;
        }
    }

    @Nullable
    private static XFlatParagraph getFlatParagraph(XFlatParagraphIterator xFlatParaIter) throws Exception {
        try {
            if (xFlatParaIter == null) {
                return null;
            }
            return xFlatParaIter.getLastPara();
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return null;
        }
    }

    private static void printException(Exception e) {
        Main.printToLogFile(Tools.getFullStackTrace(e));
    }

    public boolean isFlatParaFromIter() throws Exception {
        try {
            if (this.xFlatParaIter == null || this.xFlatPara == null) {
                return false;
            }
            return this.xFlatParaIter.getParaBefore(this.xFlatPara) != null || this.xFlatParaIter.getParaAfter(this.xFlatPara) != null;
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return false;
        }
    }

    public int getCurNumFlatParagraphs() throws Exception {
        try {
            if (this.xFlatParaIter == null || this.xFlatPara == null) {
                return -1;
            }
            int pos = -1;
            XFlatParagraph tmpXFlatPara = this.xFlatPara;
            while (tmpXFlatPara != null) {
                tmpXFlatPara = this.xFlatParaIter.getParaBefore(tmpXFlatPara);
                ++pos;
            }
            return pos;
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return -1;
        }
    }

    @Nullable
    public List<String> getAllFlatParagraphs() throws Exception {
        try {
            ArrayList<String> allParas = new ArrayList<String>();
            if (this.xFlatParaIter == null || this.xFlatPara == null) {
                return null;
            }
            XFlatParagraph tmpFlatPara = this.xFlatPara;
            while (tmpFlatPara != null) {
                allParas.add(0, tmpFlatPara.getText());
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            tmpFlatPara = this.xFlatParaIter.getParaAfter(this.xFlatPara);
            while (tmpFlatPara != null) {
                allParas.add(tmpFlatPara.getText());
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
            }
            return allParas;
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return null;
        }
    }

    public int getNumberOfAllFlatPara() throws Exception {
        try {
            if (this.xFlatParaIter == null || this.xFlatPara == null) {
                return -1;
            }
            XFlatParagraph tmpFlatPara = this.xFlatPara;
            int num = 0;
            while (tmpFlatPara != null) {
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
                ++num;
            }
            tmpFlatPara = this.xFlatPara;
            --num;
            while (tmpFlatPara != null) {
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
                ++num;
            }
            return num;
        }
        catch (Exception e) {
            LOFlatParagraph.printException(e);
            return -1;
        }
    }
}

