/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class WhiteSpaceAtBeginOfParagraph
extends Rule {
    public WhiteSpaceAtBeginOfParagraph(ResourceBundle messages, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setOfficeDefaultOn();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public WhiteSpaceAtBeginOfParagraph(ResourceBundle messages) {
        this(messages, false);
    }

    @Override
    public String getId() {
        return "WHITESPACE_PARAGRAPH_BEGIN";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("whitespace_at_begin_parapgraph_desc");
    }

    private boolean isWhitespaceDel(AnalyzedTokenReadings token) {
        return token.isWhitespace() && !token.getToken().equals("\u200b") && !token.isLinebreak();
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        int i;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        for (i = 1; i < tokens.length && this.isWhitespaceDel(tokens[i]); ++i) {
        }
        if (i > 1 && i < tokens.length && !tokens[i].isLinebreak()) {
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, tokens[1].getStartPos(), tokens[i].getEndPos(), this.messages.getString("whitespace_at_begin_parapgraph_msg"));
            ruleMatch.setSuggestedReplacement(tokens[i].getToken());
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

