/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.AttrDecl;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definition;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.OpDecl;
import org.jacorb.idl.Operation;
import org.jacorb.idl.ReplyHandler;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class InterfaceBody
extends IdlSymbol {
    public Vector<Definition> v = new Vector();
    public Interface my_interface;
    SymbolList inheritance_spec = null;
    private Operation[] methods = null;
    private String waitingName = "";
    private static Vector<ParseThread> parseThreads = new Vector();

    public InterfaceBody(int num) {
        super(num);
    }

    public void commit() {
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            ((IdlSymbol)e.nextElement()).setEnclosingSymbol(this.my_interface);
        }
    }

    public void set_ancestors(SymbolList _inheritance_spec) {
        this.inheritance_spec = _inheritance_spec;
    }

    @Override
    public void set_name(String n) {
        this.name = n;
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            ((IdlSymbol)e.nextElement()).setPackage(this.name);
        }
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            ((IdlSymbol)e.nextElement()).setPackage(s);
        }
    }

    public void addDefinition(Declaration d) {
        this.v.add(new Definition(d));
    }

    @Override
    public void parse() {
        this.escapeName();
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "Interface Body parse " + this.full_name());
        }
        if (this.inheritance_spec != null) {
            Object o = null;
            boolean pending = false;
            Enumeration e = this.inheritance_spec.v.elements();
            while (e.hasMoreElements()) {
                ScopedName scoped_name = (ScopedName)e.nextElement();
                if (parser.logger.isLoggable(Level.ALL)) {
                    parser.logger.log(Level.ALL, "Trying to resolve " + scoped_name);
                }
                o = parser.get_pending(scoped_name.resolvedName());
                pending = pending || o != null;
            }
            if (pending) {
                parser.set_pending(this.full_name(), o);
                new ParseThread(this);
            } else {
                this.internal_parse();
                parser.remove_pending(this.full_name());
            }
        } else {
            this.internal_parse();
            parser.remove_pending(this.full_name());
            if (parser.logger.isLoggable(Level.ALL)) {
                parser.logger.log(Level.ALL, "Interface Body done parsing " + this.full_name());
            }
        }
    }

    public void internal_parse() {
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "Interface Body internal_parse " + this.full_name());
        }
        if (this.inheritance_spec != null) {
            try {
                NameTable.inheritFrom(this.full_name(), this.inheritance_spec);
            }
            catch (NameAlreadyDefined nad) {
                parser.fatal_error("Name " + nad.getMessage() + " already defined in  base interface(s)", this.token);
            }
        }
        Definition d = null;
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            d = e.nextElement();
            Declaration dec = d.get_declaration();
            if (this.is_pseudo) {
                dec.set_pseudo();
            }
            dec.parse();
        }
    }

    @Override
    public void print(PrintWriter ps) {
        if (ps != null) {
            throw new RuntimeException("Compiler Error, interface body cannot be printed thus!");
        }
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            Declaration d = e.nextElement().get_declaration();
            if (d instanceof OpDecl) continue;
            d.print(ps);
        }
    }

    public void printOperationSignatures(PrintWriter ps) {
        if (this.v.size() > 0) {
            ps.println("\t/* operations  */");
        }
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            Definition d = e.nextElement();
            if (d.get_declaration() instanceof OpDecl) {
                ((OpDecl)d.get_declaration()).printSignature(ps);
                continue;
            }
            if (!(d.get_declaration() instanceof AttrDecl)) continue;
            Enumeration m = ((AttrDecl)d.get_declaration()).getOperations();
            while (m.hasMoreElements()) {
                ((Operation)m.nextElement()).printSignature(ps);
            }
        }
    }

    public void printConstants(PrintWriter ps) {
        if (this.v.size() > 0) {
            ps.println("\t/* constants */");
        }
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            Definition d = e.nextElement();
            if (!(d.get_declaration() instanceof ConstDecl)) continue;
            ((ConstDecl)d.get_declaration()).printContained(ps);
        }
    }

    public void printInterfaceMethods(PrintWriter ps) {
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            Definition d = e.nextElement();
            if (d.get_declaration() instanceof ConstDecl || !this.is_pseudo()) continue;
            ((IdlSymbol)d).print(ps);
        }
    }

    public Operation[] getMethods() {
        if (this.methods == null) {
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            Enumeration<Definition> e = this.v.elements();
            while (e.hasMoreElements()) {
                Definition d = e.nextElement();
                if (d.get_declaration() instanceof OpDecl) {
                    table.put(((OpDecl)d.get_declaration()).signature(), d.get_declaration());
                    continue;
                }
                if (!(d.get_declaration() instanceof AttrDecl)) continue;
                Enumeration elems = ((AttrDecl)d.get_declaration()).getOperations();
                while (elems.hasMoreElements()) {
                    Operation op = (Operation)elems.nextElement();
                    table.put(op.signature(), op);
                }
            }
            Iterator i = this.my_interface.inheritanceSpec.v.iterator();
            while (i.hasNext()) {
                TypeSpec ts = ((ScopedName)i.next()).resolvedTypeSpec();
                if (ts instanceof AliasTypeSpec && ((AliasTypeSpec)ts).originalType() instanceof ConstrTypeSpec) {
                    ts = ((AliasTypeSpec)ts).originalType();
                }
                if (!(ts instanceof ConstrTypeSpec)) continue;
                Interface base = (Interface)((ConstrTypeSpec)ts).c_type_spec;
                Operation[] base_ops = base.getBody().getMethods();
                for (int j = 0; j < base_ops.length; ++j) {
                    if (table.contains(base_ops[j].signature())) continue;
                    table.put(base_ops[j].signature(), base_ops[j]);
                }
            }
            Enumeration o = table.elements();
            this.methods = new Operation[table.size()];
            for (int i2 = 0; i2 < this.methods.length; ++i2) {
                this.methods[i2] = (Operation)o.nextElement();
            }
        }
        return this.methods;
    }

    public void printStubMethods(PrintWriter ps, String classname, boolean is_local, boolean is_abstract) {
        int i;
        Operation[] ops = this.getMethods();
        for (i = 0; i < ops.length; ++i) {
            ops[i].printMethod(ps, classname, is_local, is_abstract);
        }
        if (parser.generate_ami_callback && !(this.my_interface instanceof ReplyHandler)) {
            for (i = 0; i < ops.length; ++i) {
                ops[i].print_sendc_Method(ps, classname);
            }
        }
    }

    public void printDelegatedMethods(PrintWriter ps) {
        Operation[] ops = this.getMethods();
        if (ops.length > 0) {
            for (int i = 0; i < ops.length; ++i) {
                ops[i].printDelegatedMethod(ps);
            }
        }
    }

    public void printOperationsHash(PrintWriter ps) {
        Operation[] ops = this.getMethods();
        if (ops.length == 0) {
            return;
        }
        ps.print("\tstatic private final java.util.HashMap<String,Integer>");
        ps.println(" m_opsHash = new java.util.HashMap<String,Integer>();");
        ps.println("\tstatic");
        ps.println("\t{");
        for (int i = 0; i < ops.length; ++i) {
            String name = ops[i] instanceof OpDecl && ops[i].opName().startsWith("_") && !(((OpDecl)ops[i]).myInterface instanceof ReplyHandler) ? ops[i].opName().substring(1) : ops[i].opName();
            ps.println("\t\tm_opsHash.put ( \"" + name + "\", Integer.valueOf(" + i + "));");
        }
        ps.println("\t}");
    }

    public void printSkelInvocations(PrintWriter ps) {
        Operation[] ops = this.getMethods();
        if (ops.length <= 0) {
            ps.println("\t\tthrow new org.omg.CORBA.BAD_OPERATION(method + \" not found\");");
            return;
        }
        ps.println("\t\t// quick lookup of operation");
        ps.println("\t\tjava.lang.Integer opsIndex = (java.lang.Integer)m_opsHash.get ( method );");
        ps.println("\t\tif ( null == opsIndex )");
        ps.println("\t\t\tthrow new org.omg.CORBA.BAD_OPERATION(method + \" not found\");");
        ps.println("\t\tswitch ( opsIndex.intValue() )");
        ps.println("\t\t{");
        int nextIndex = 0;
        for (int i = 0; i < ops.length; ++i) {
            String name = ops[i] instanceof OpDecl && ops[i].opName().startsWith("_") ? ops[i].opName().substring(1) : ops[i].opName();
            ps.println("\t\t\tcase " + nextIndex++ + ": // " + name);
            ps.println("\t\t\t{");
            ops[i].printInvocation(ps);
            ps.println("\t\t\t\tbreak;");
            ps.println("\t\t\t}");
        }
        ps.println("\t\t}");
        ps.println("\t\treturn _out;");
    }

    void getIRInfo(Hashtable irInfoTable) {
        Enumeration<Definition> e = this.v.elements();
        while (e.hasMoreElements()) {
            Definition d = e.nextElement();
            if (d.get_declaration() instanceof OpDecl) {
                ((OpDecl)d.get_declaration()).getIRInfo(irInfoTable);
                continue;
            }
            if (!(d.get_declaration() instanceof AttrDecl)) continue;
            ((AttrDecl)d.get_declaration()).getIRInfo(irInfoTable);
        }
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitInterfaceBody(this);
    }

    static void clearParseThreads() {
        parseThreads.clear();
    }

    public class ParseThread
    extends Thread {
        private final InterfaceBody b;
        private boolean running = false;

        public ParseThread(InterfaceBody _b) {
            this.b = _b;
            this.setDaemon(true);
            parseThreads.addElement(this);
            parser.incActiveParseThreads();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            parser.set_pending(this.b.full_name(), this.b);
            Object o = null;
            Enumeration e = InterfaceBody.this.inheritance_spec.v.elements();
            while (e.hasMoreElements()) {
                InterfaceBody.this.waitingName = ((ScopedName)e.nextElement()).resolvedName();
                o = parser.get_pending(InterfaceBody.this.waitingName);
                if (o == null) continue;
                try {
                    Object object = o;
                    synchronized (object) {
                        o.wait();
                        this.running = true;
                    }
                }
                catch (InterruptedException ie) {
                    parser.logger.log(Level.FINEST, "ParseThread " + this + " interrupted!");
                }
            }
            this.b.internal_parse();
            this.exitParseThread();
        }

        public synchronized boolean isRunnable() {
            boolean result;
            boolean bl = result = this.running || this.checkWaitCondition();
            if (parser.logger.isLoggable(Level.WARNING)) {
                parser.logger.log(Level.WARNING, "Thread is runnable: " + result);
            }
            return result;
        }

        private synchronized void exitParseThread() {
            parser.remove_pending(this.b.full_name());
            parser.decActiveParseThreads();
            parseThreads.removeElement(this);
            this.running = false;
        }

        private boolean checkWaitCondition() {
            return parser.get_pending(InterfaceBody.this.waitingName) == null;
        }
    }
}

