/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.IProxyPushSupplier;

public class TaskProcessorRetryStrategy
extends AbstractRetryStrategy
implements PushTaskExecutor.PushTask {
    public final Runnable retryPushOperation_ = new Runnable(){

        @Override
        public void run() {
            if (TaskProcessorRetryStrategy.this.pushSupplier_.isRetryAllowed()) {
                TaskProcessorRetryStrategy.this.pushSupplier_.scheduleTask(TaskProcessorRetryStrategy.this);
            } else {
                TaskProcessorRetryStrategy.this.dispose();
            }
        }
    };
    private final AtomicBoolean isCancelled_ = new AtomicBoolean(false);
    private final TaskProcessor taskProcessor_;
    private final long backoutInterval_;

    public TaskProcessorRetryStrategy(IProxyPushSupplier pushSupplier, PushOperation pushOperation, TaskProcessor taskProcessor, long backoutInterval) {
        super(pushSupplier, pushOperation);
        this.taskProcessor_ = taskProcessor;
        this.backoutInterval_ = backoutInterval;
    }

    @Override
    protected long getTimeToWait() {
        return 0L;
    }

    @Override
    protected void retryInternal() throws RetryException {
        if (this.pushSupplier_.isRetryAllowed()) {
            this.pushSupplier_.disableDelivery();
            this.taskProcessor_.executeTaskAfterDelay(this.backoutInterval_, this.retryPushOperation_);
        }
    }

    @Override
    public void doPush() {
        if (!this.isCancelled_.get()) {
            try {
                if (this.pushSupplier_.isRetryAllowed()) {
                    this.pushOperation_.invokePush();
                    this.pushSupplier_.scheduleFlush();
                }
                this.dispose();
            }
            catch (Exception error) {
                try {
                    this.remoteExceptionOccured(error);
                    this.retry();
                }
                catch (RetryException e) {
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void cancel() {
        this.isCancelled_.set(true);
        this.dispose();
    }
}

