/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection.util;

import java.util.Enumeration;
import org.jacorb.collection.util.DynArray;
import org.jacorb.collection.util.ObjectComparator;
import org.jacorb.collection.util.ObjectInvalid;

public class SortedVector {
    private final DynArray data;
    private final ObjectComparator cmpr;

    public SortedVector(ObjectComparator cmpr) {
        this.data = new DynArray();
        this.cmpr = cmpr;
    }

    public SortedVector(ObjectComparator cmpr, int capacity) {
        this.data = new DynArray(capacity);
        this.cmpr = cmpr;
    }

    public int addElement(Object obj) throws ObjectInvalid {
        int pos;
        this.cmpr.element(obj);
        if (pos > -1 && this.cmpr.compare_with(this.data.elementAt(0)) >= 0) {
            for (pos = this.find_nearest(); pos < this.data.size() && this.cmpr.compare_with(this.data.elementAt(pos)) >= 0; ++pos) {
            }
        } else {
            pos = 0;
        }
        this.data.insertElementAt(obj, pos);
        return pos;
    }

    public int size() {
        return this.data.size();
    }

    public Object elementAt(int index) {
        return this.data.elementAt(index);
    }

    public Enumeration elements() {
        return this.data.elements();
    }

    public Object removeElementAt(int index) {
        Object obj = this.data.elementAt(index);
        this.data.removeElementAt(index);
        return obj;
    }

    public void removeAllElements() {
        this.data.removeAllElements();
    }

    public int indexOf(Object obj) throws ObjectInvalid {
        int j;
        this.cmpr.element(obj);
        int i = this.find_nearest();
        if (i == this.data.size()) {
            --i;
        }
        if (i >= this.data.size() || i < 0) {
            return -1;
        }
        for (j = i; j >= 0 && this.cmpr.compare_with(this.data.elementAt(j)) <= 0; --j) {
            if (!this.cmpr.equal(this.data.elementAt(j))) continue;
            return j;
        }
        for (j = i + 1; j < this.data.size() && this.cmpr.compare_with(this.data.elementAt(j)) >= 0; ++j) {
            if (!this.cmpr.equal(this.data.elementAt(j))) continue;
            return j;
        }
        return -1;
    }

    public void setElementAt(Object obj, int index) throws ObjectInvalid {
        if (!this.isIndexValid(index, obj)) {
            throw new ObjectInvalid();
        }
        this.data.setElementAt(obj, index);
    }

    public boolean isIndexValid(int index, Object obj) throws ObjectInvalid {
        this.cmpr.element(obj);
        if (this.data.size() == 0) {
            return true;
        }
        int i = this.find_nearest();
        if (this.cmpr.equal(this.data.elementAt(i))) {
            return true;
        }
        return !(i != 0 && this.cmpr.compare_with(this.data.elementAt(i - 1)) < 0 || i != this.data.size() && this.cmpr.compare_with(this.data.elementAt(i)) > 0);
    }

    public boolean insertElementAt(Object obj, int index) throws ObjectInvalid {
        if (this.isIndexValid(index, obj)) {
            this.data.insertElementAt(obj, index);
        }
        return false;
    }

    private int find_nearest() throws ObjectInvalid {
        if (this.data.size() == 0) {
            return -1;
        }
        int first = 0;
        if (this.cmpr.compare_with(this.data.elementAt(first)) <= 0) {
            return first;
        }
        int last = this.data.size() - 1;
        if (this.cmpr.compare_with(this.data.elementAt(last)) >= 0) {
            return this.data.size();
        }
        if (first == last) {
            if (this.cmpr.compare_with(this.data.elementAt(last)) <= 0) {
                return first;
            }
            return first + 1;
        }
        int result = 0;
        int pos = first;
        while (first < last) {
            pos = (first + last) / 2;
            if (pos == first) {
                return ++pos;
            }
            if (pos == last) {
                return ++pos;
            }
            result = this.cmpr.compare_with(this.data.elementAt(pos));
            if (result == 0) {
                return ++pos;
            }
            if (result > 0) {
                first = pos;
                continue;
            }
            last = pos;
        }
        return pos;
    }
}

