/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import org.jacorb.poa.gui.beans.FillLevelCanvas;

public class FillLevelBar
extends Panel {
    private boolean useAvg;
    private boolean isVariable;
    private int max;
    private int avg;
    private int min;
    private int cur;
    private Label ivjAvgLabel = null;
    private Label ivjCurLabel = null;
    private Label ivjMaxLabel = null;
    private Label ivjMinLabel = null;
    private FillLevelCanvas ivjFillLevelCanvas = null;

    public FillLevelBar() {
        this.initialize();
    }

    public FillLevelBar(LayoutManager layout) {
        super(layout);
    }

    private Label getAvgLabel() {
        if (this.ivjAvgLabel == null) {
            try {
                this.ivjAvgLabel = new Label();
                this.ivjAvgLabel.setName("AvgLabel");
                this.ivjAvgLabel.setText("");
                this.ivjAvgLabel.setBackground(SystemColor.control);
                this.ivjAvgLabel.setFont(new Font("dialog", 0, 10));
                this.ivjAvgLabel.setBounds(23, 54, 25, 10);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAvgLabel;
    }

    private Label getCurLabel() {
        if (this.ivjCurLabel == null) {
            try {
                this.ivjCurLabel = new Label();
                this.ivjCurLabel.setName("CurLabel");
                this.ivjCurLabel.setText("");
                this.ivjCurLabel.setBackground(SystemColor.control);
                this.ivjCurLabel.setFont(new Font("dialog", 0, 10));
                this.ivjCurLabel.setAlignment(1);
                this.ivjCurLabel.setBounds(0, 115, 25, 12);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCurLabel;
    }

    private FillLevelCanvas getFillLevelCanvas() {
        if (this.ivjFillLevelCanvas == null) {
            try {
                this.ivjFillLevelCanvas = new FillLevelCanvas();
                this.ivjFillLevelCanvas.setName("FillLevelCanvas");
                this.ivjFillLevelCanvas.setBounds(5, 10, 15, 100);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFillLevelCanvas;
    }

    private Label getMaxLabel() {
        if (this.ivjMaxLabel == null) {
            try {
                this.ivjMaxLabel = new Label();
                this.ivjMaxLabel.setName("MaxLabel");
                this.ivjMaxLabel.setText("");
                this.ivjMaxLabel.setBackground(SystemColor.control);
                this.ivjMaxLabel.setFont(new Font("dialog", 0, 10));
                this.ivjMaxLabel.setBounds(23, 7, 25, 10);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMaxLabel;
    }

    private Label getMinLabel() {
        if (this.ivjMinLabel == null) {
            try {
                this.ivjMinLabel = new Label();
                this.ivjMinLabel.setName("MinLabel");
                this.ivjMinLabel.setText("");
                this.ivjMinLabel.setBackground(SystemColor.control);
                this.ivjMinLabel.setFont(new Font("dialog", 0, 10));
                this.ivjMinLabel.setBounds(23, 104, 25, 10);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMinLabel;
    }

    private void handleException(Throwable exception) {
    }

    public void init(int _min, int _avg, int _max, Color _color1, Color _color2, boolean _useAvg, boolean _isVariable) {
        this.min = _min;
        this.avg = _avg;
        this.max = _max;
        this.useAvg = _useAvg;
        this.getFillLevelCanvas().init(this.min, this.avg, this.max, _color1, _color2, this.useAvg);
        this.isVariable = _isVariable;
        if (this.useAvg) {
            this.getAvgLabel().setText("" + _avg);
            this.getAvgLabel().setLocation(23, this.getFillLevelCanvas().getYAvg() + 6);
        }
        this.getMaxLabel().setText("" + _max);
        this.getMinLabel().setText("" + _min);
        this.getCurLabel().setText("" + _min);
    }

    private void initialize() {
        this.setName("FillLevelBar");
        this.setLayout(null);
        this.setBackground(SystemColor.control);
        this.setSize(50, 130);
        this.add((Component)this.getCurLabel(), this.getCurLabel().getName());
        this.add((Component)this.getMinLabel(), this.getMinLabel().getName());
        this.add((Component)this.getMaxLabel(), this.getMaxLabel().getName());
        this.add((Component)this.getAvgLabel(), this.getAvgLabel().getName());
        this.add((Component)this.getFillLevelCanvas(), this.getFillLevelCanvas().getName());
    }

    public static void main(String[] args) {
        try {
            Frame frame;
            try {
                Class<?> aFrameClass = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
                frame = (Frame)aFrameClass.newInstance();
            }
            catch (Throwable ivjExc) {
                frame = new Frame();
            }
            FillLevelBar aFillLevelBar = new FillLevelBar();
            frame.add("Center", aFillLevelBar);
            frame.setSize(aFillLevelBar.getSize());
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of java.awt.Panel");
            exception.printStackTrace(System.out);
        }
    }

    private int maxCompute(int current) {
        block3: {
            int tenPerCent;
            block2: {
                tenPerCent = this.max / 10;
                if (current >= tenPerCent) break block2;
                while (this.max > current * 2 && this.max > 10) {
                    this.max = this.max / 2 > 10 ? this.max / 2 : 10;
                }
                break block3;
            }
            if (current <= this.max - tenPerCent) break block3;
            while (this.max < current + tenPerCent) {
                this.max *= 2;
            }
        }
        return this.max;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fill3DRect(3, 8, 19, 104, false);
    }

    public void setAvgValue(int value) {
        if (this.avg == value) {
            return;
        }
        this.avg = value;
        if (this.useAvg) {
            this.getFillLevelCanvas().setAvg(this.avg);
            this.getAvgLabel().setLocation(23, this.getFillLevelCanvas().getYAvg() + 6);
            this.getAvgLabel().setText("" + this.avg);
        }
    }

    public void setCurrentValue(int value) {
        if (this.cur == value) {
            return;
        }
        this.cur = value;
        if (this.isVariable && this.max != this.maxCompute(this.cur)) {
            this.getFillLevelCanvas().setMax(this.max);
            this.getMaxLabel().setText("" + this.max);
        }
        this.getFillLevelCanvas().setCurrent(this.cur > this.min ? this.cur - this.min : 0);
        this.getCurLabel().setText("" + this.cur);
    }

    public void setMaxValue(int value) {
        if (this.max == value) {
            return;
        }
        this.max = value;
        this.getFillLevelCanvas().setMax(this.max);
        if (this.useAvg) {
            this.getAvgLabel().setLocation(23, this.getFillLevelCanvas().getYAvg() + 6);
        }
        this.getMaxLabel().setText("" + this.max);
    }

    public void setMinValue(int value) {
        if (this.min == value) {
            return;
        }
        this.min = value;
        this.getFillLevelCanvas().setMin(this.min);
        if (this.useAvg) {
            this.getAvgLabel().setLocation(23, this.getFillLevelCanvas().getYAvg() + 6);
        }
        this.getFillLevelCanvas().setCurrent(this.cur > this.min ? this.cur - this.min : 0);
        this.getMinLabel().setText("" + this.min);
    }
}

