/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IRNodeWithType;
import org.jacorb.ir.gui.typesystem.remote.IRParameter;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.ParameterDescription;

public class IROperation
extends IRNodeWithType
implements AbstractContainer {
    protected IRParameter[] parameters;
    protected IRException[] exceptions;
    private String instanceNodeTypeName;
    private OperationDef operationDef;

    public IROperation() {
    }

    public IROperation(IRObject irObject) {
        super(irObject);
        this.operationDef = OperationDefHelper.narrow((Object)irObject);
        this.setAssociatedTypeSystemNode(RemoteTypeSystem.createTypeSystemNode(this.operationDef.result_def()));
        String dummy = super.getInstanceNodeTypeName();
        if (this.operationDef.mode().value() == 1) {
            dummy = "oneway " + dummy;
        }
        this.instanceNodeTypeName = dummy;
    }

    @Override
    public ModelParticipant[] contents() {
        OperationDef operationDef = OperationDefHelper.narrow((Object)this.irObject);
        ParameterDescription[] contents = operationDef.params();
        ModelParticipant[] result = new TypeSystemNode[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            result[i] = RemoteTypeSystem.createTypeSystemNode(contents[i]);
        }
        return result;
    }

    @Override
    public String getInstanceNodeTypeName() {
        return this.instanceNodeTypeName;
    }

    public static String nodeTypeName() {
        return "operation";
    }

    @Override
    public String description() {
        String result = super.description();
        if (this.exceptions == null) {
            ExceptionDef[] exceptionDefs = this.operationDef.exceptions();
            this.exceptions = new IRException[exceptionDefs.length];
            for (int i = 0; i < exceptionDefs.length; ++i) {
                this.exceptions[i] = (IRException)RemoteTypeSystem.createTypeSystemNode(exceptionDefs[i]);
            }
        }
        if (this.exceptions.length > 0) {
            result = result + "\nExceptions:\t ";
            for (int i = 0; i < this.exceptions.length; ++i) {
                result = result + ((TypeSystemNode)this.exceptions[i]).getAbsoluteName();
                if (i == this.exceptions.length - 1) continue;
                result = result + ", ";
            }
        } else {
            result = result + "\nExceptions:\t:none";
        }
        return result;
    }
}

