//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsWorkspace_c.h, C++ API dsWorkspace_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsWorkspace_p;
class dsWorkspace;
class dsMenuItem_c;
class dsToolbar_c;
class dsRibbonQuickAccessBar_c;
class dsRibbonSystemMenu_c;
class dsRibbonTab_c;
class dsRibbonPanel_c;

class DSINTERFACE_EXPORT dsWorkspace_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsWorkspace)
public:
	DSRESULT IsSame(dsWorkspace_c* dsObj);

	DSRESULT Activate( );
	DSRESULT Remove( );
	DSRESULT IsActive(bool * Val);
	DSRESULT GetMenuItems(dsObjectPtrArray * MenuItemArray);
	DSRESULT AddMenu(const dsString&  ApiUuid, long  Position, const dsString&  MenuName, dsMenuItem_c ** menuItem);
	DSRESULT GetToolbars(dsObjectPtrArray * ToolbarArray);
	DSRESULT AddToolbar(const dsString&  ApiUuid, const dsString&  ToolBarName, dsToolbar_c ** Toolbar);
	DSRESULT GetRibbonQuickAccessBar(dsRibbonQuickAccessBar_c ** RibbonQuickAccessBar);
	DSRESULT AddRibbonQuickAccessBar(const dsString&  ApiUuid, const dsString&  Name, dsRibbonQuickAccessBar_c ** RibbonQuickAccessBar);
	DSRESULT GetRibbonSystemMenu(dsRibbonSystemMenu_c ** RibbonSystemMenu);
	DSRESULT AddRibbonSystemMenu(const dsString&  ApiUuid, dsRibbonSystemMenu_c ** RibbonSystemMenu);
	DSRESULT GetRibbonTabs(dsObjectPtrArray * RibbonTabArray);
	DSRESULT AddRibbonTab(const dsString&  ApiUuid, long  Position, const dsString&  TabName, const dsString&  DisplayText, dsRibbonTab_c ** RibbonTab);
	DSRESULT GetRibbonPanels(dsObjectPtrArray * RibbonPanelArray);
	DSRESULT AddRibbonPanel(const dsString&  ApiUuid, long  Position, const dsString&  PanelName, const dsString&  DisplayText, const dsObjectPtrArray& RibbonTabArray, dsRibbonPanel_c ** RibbonPanel);
	DSRESULT get_UIState(dsUIState_e*  Val);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
};
