//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsViewport_c.h, C++ API dsViewport_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsTransparency_c;
class dsViewport_p;
class dsViewport;
class dsViewport_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsColor_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsViewport_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsViewport)
public:
	DSRESULT IsSame(dsViewport_c* dsObj);

	DSRESULT get_Layer(dsString*  Val);
	DSRESULT put_Layer(const dsString&  NewVal);
	DSRESULT get_LineStyle(dsString*  Val);
	DSRESULT put_LineStyle(const dsString&  NewVal);
	DSRESULT get_LineScale(double * Val);
	DSRESULT put_LineScale(double  NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);
	DSRESULT get_Visible(bool * Val);
	DSRESULT put_Visible(bool  NewVal);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT get_Handle(dsString*  Val);
	//DSRESULT put_Handle(const dsString&  NewVal);
	DSRESULT get_Height(double * Val);
	DSRESULT put_Height(double  NewVal);
	DSRESULT get_Width(double * Val);
	DSRESULT put_Width(double  NewVal);
	DSRESULT get_CCSPerViewport(bool * Val);
	DSRESULT put_CCSPerViewport(bool  NewVal);
	DSRESULT get_StandardScale(dsViewportStandardScale_e* Val);
	DSRESULT put_StandardScale(dsViewportStandardScale_e NewVal);
	DSRESULT get_CustomScale(double * Val);
	DSRESULT put_CustomScale(double  NewVal);
	DSRESULT get_DisplayLocked(bool * Val);
	DSRESULT put_DisplayLocked(bool  NewVal);
	DSRESULT get_IsOn(bool * Val);
	DSRESULT put_IsOn(bool  NewVal);
	DSRESULT get_Active(bool * Val);
	DSRESULT put_Active(bool  NewVal);
	DSRESULT get_ShadePrintStyle(dsViewportShadePrintStyle_e* Val);
	DSRESULT put_ShadePrintStyle(dsViewportShadePrintStyle_e NewVal);
	DSRESULT Select(bool  SelectFlag, bool * Res);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT GetCenter(double * X, double * Y, double * Z);
	DSRESULT SetCenter(double  X, double  Y, double  Z);
	DSRESULT GetIsClipped(bool * IsClipped);
	DSRESULT GetClippedObject(dsObjectType_e* ObjType, dsObject ** ClippedObject);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
	DSRESULT get_ViewHeight(double * Val);
	DSRESULT GetViewCenter(double * X, double * Y);
};
