//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsViewTile_c.h, C++ API dsViewTile_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsViewTile_p;
class dsViewTile;
class dsCustomData_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsViewTile_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsViewTile)
public:
	DSRESULT IsSame(dsViewTile_c* dsObj);

	DSRESULT get_Handle(dsString*  Val);
	DSRESULT get_Active(  bool* Val);
	DSRESULT put_Active(  bool NewVal );
	DSRESULT get_CCSPerViewTile(  bool* Val);
	DSRESULT put_CCSPerViewTile(  bool NewVal );
	DSRESULT get_CSIconAtOrigin(  bool* Val);
	DSRESULT put_CSIconAtOrigin(  bool NewVal );
	DSRESULT get_CSIconIsOn(  bool* Val);
	DSRESULT put_CSIconIsOn(  bool NewVal );
	DSRESULT ActivateView(const dsString&  Name);
	DSRESULT Join(dsViewTile_c * ViewTile);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
