//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsToolbar_c.h, C++ API dsToolbar_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"


class dsToolbarItem_c;
class dsToolbar_p;
class dsToolbar;
class DSINTERFACE_EXPORT dsToolbar_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsToolbar)
public:
	DSRESULT IsSame(dsToolbar_c* Obj);

	DSRESULT GetToolbarItems(dsObjectPtrArray* ToolbarItemArray);
	DSRESULT InsertToolbarItem(const dsString& ApiUuid, dsToolbarItemType_e ItemType, long Position, const dsString& ItemName, const dsString& UserCmdID, dsToolbarItem_c** Item);


	DSRESULT Remove( );
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
	DSRESULT get_Visible(bool*  Val);
	DSRESULT put_Visible(bool  NewVal);
    DSRESULT GetID(dsString* ID);
};