//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsToolbarItem_c.h, C++ API dsToolbarItem_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsToolbarItem_p;
class dsToolbarItem;
class DSINTERFACE_EXPORT dsToolbarItem_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsToolbarItem)
public:
	DSRESULT IsSame(dsToolbarItem_c* Obj);

	DSRESULT GetType(dsToolbarItemType_e* ItemType);
	DSRESULT get_Name(dsString* Val);
	DSRESULT put_Name(const dsString& NewVal);
	DSRESULT get_Enabled(bool* Val);
	DSRESULT put_Enabled(bool NewVal);

	DSRESULT Remove( );
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Visible(bool * Val);
	DSRESULT put_Visible(bool  NewVal);
    DSRESULT GetID(dsString* ID);
};
