//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSheetNamedView_c.h, C++ API dsSheetNamedView_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsSheetNamedView_p;
class dsSheetNamedView;
class dsNamedView_c;
class dsSheet_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsSheetNamedView_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsSheetNamedView)
public:
	DSRESULT IsSame(dsSheetNamedView_c* dsObj);

	DSRESULT GetNamedView(dsNamedView_c ** NamedView);
	DSRESULT GetSheet(dsSheet_c ** Sheet);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
