//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRichLineStyleManager_c.h, C++ API dsRichLineStyleManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsRichLineStyleManager_p;
class dsRichLineStyleManager;
class dsRichLineStyle_c;
class DSINTERFACE_EXPORT dsRichLineStyleManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRichLineStyleManager)
public:
	DSRESULT IsSame(dsRichLineStyleManager_c* dsObj);

	DSRESULT CreateRichLineStyle(const dsString&  Name, dsRichLineStyle_c** RichLineStyle, dsCreateObjectResult_e* Result);
	DSRESULT GetRichLineStyle(const dsString&  Name, dsRichLineStyle_c ** RichLineStyle);
	DSRESULT GetRichLineStyles(dsObjectPtrArray * RichLineStyleArray);
	DSRESULT RemoveRichLineStyle(const dsString&  Name, bool * Result);
	DSRESULT GetActiveRichLineStyle(dsRichLineStyle_c ** RichLineStyle);
};
