//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonTab_c.h, C++ API dsRibbonTab_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonTab_p;
class dsRibbonTab;
class dsRibbonPanel_c;
class DSINTERFACE_EXPORT dsRibbonTab_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonTab)
public:
	DSRESULT IsSame(dsRibbonTab_c* dsObj);

	DSRESULT GetRibbonPanels(dsObjectPtrArray * RibbonPanelArray);
	DSRESULT InsertRibbonPanel(const dsString&  ApiUuid, long  Position, const dsString&  PanelName, const dsString&  DisplayText, dsRibbonPanel_c ** RibbonPanel);
	DSRESULT Remove( );
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
	DSRESULT get_DisplayText(dsString*  Val);
	DSRESULT put_DisplayText(const dsString&  NewVal);
};
