//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonSystemMenu_c.h, C++ API dsRibbonSystemMenu_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonSystemMenu_p;
class dsRibbonSystemMenu;
class dsRibbonSystemMenuItem_c;
class DSINTERFACE_EXPORT dsRibbonSystemMenu_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonSystemMenu)
public:
	DSRESULT IsSame(dsRibbonSystemMenu_c* dsObj);

	DSRESULT GetRibbonSystemMenuItems(dsObjectPtrArray * RibbonSystemMenuItemArray);
	DSRESULT InsertRibbonSystemMenuItem(const dsString&  ApiUuid, dsRibbonItemType_e  ItemType, long  Position, const dsString&  ItemName, const dsString&  UserCmdID, dsRibbonSystemMenuItem_c ** RibbonSystemMenuItem);
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT Remove( );
};
