//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRadialDimension_c.h, C++ API dsRadialDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRadialDimension_p;
class dsRadialDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsRadialDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRadialDimension)
public:
	DSRESULT IsSame(dsRadialDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetDefiningPoint(double * X, double * Y, double * Z);
	DSRESULT SetDefiningPoint(double  X, double  Y, double  Z);
	DSRESULT GetCenterPoint(double * X, double * Y, double * Z);
	DSRESULT SetCenterPoint(double  X, double  Y, double  Z);
	DSRESULT get_LeaderLength(double * Val);
	DSRESULT put_LeaderLength(double  NewVal);
};
