//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsPolygonMesh_c.h, C++ API dsPolygonMesh_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTransparency_c;
class dsPolygonMesh_p;
class dsPolygonMesh;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsPolygonMesh_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsPolygonMesh)
public:
	DSRESULT IsSame(dsPolygonMesh_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);

	DSRESULT get_MClosed(bool * Val);
	DSRESULT put_MClosed(bool  NewVal);
	DSRESULT get_NClosed(bool * Val);
	DSRESULT put_NClosed(bool  NewVal);
	DSRESULT get_MDensity(long * Val);
	DSRESULT put_MDensity(long  NewVal);
	DSRESULT get_NDensity(long * Val);
	DSRESULT put_NDensity(long  NewVal);
	DSRESULT get_FitSmooth(dsPolygonMeshFitSmooth_e* Val);
	DSRESULT put_FitSmooth(dsPolygonMeshFitSmooth_e NewVal);
	DSRESULT GetVerticesCount(long * Val);
	DSRESULT GetVertexCoordinate(long  VertexIndex, double * X, double * Y, double * Z, bool * Success);
	DSRESULT SetVertexCoordinate(long  VertexIndex, double  X, double  Y, double  Z, bool * Success);
	DSRESULT GetMVertexCount(long * MVertexCount);
	DSRESULT GetNVertexCount(long * NVertexCount);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
