//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsNamedView_c.h, C++ API dsNamedView_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsMathPoint_c.h"
#include "dsCustomCoordinateSystem_c.h"

class dsNamedView_p;
class dsNamedView;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsNamedView_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsNamedView)
public:
	DSRESULT IsSame(dsNamedView_c* dsObj);

	DSRESULT GetName(dsString*  Name);
	DSRESULT Rename(const dsString&  NewName, dsCreateObjectResult_e* Result);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT GetWindow(dsMathPoint_c ** FirstCorner, dsMathPoint_c ** OppositeCorner);
    DSRESULT SetWindow(dsMathPoint_c * FirstCorner, dsMathPoint_c * OppositeCorner);
	DSRESULT get_Class(dsString*  Val);
	DSRESULT put_Class(const dsString&  NewVal);
	DSRESULT RemoveCustomCoordinateSystem( );
	DSRESULT GetCustomCoordinateSystem(dsCustomCoordinateSystem_c  ** CustomCoordinateSystem);
	DSRESULT SetCustomCoordinateSystem(dsCustomCoordinateSystem_c * CustomCoordinateSystem);
};
