//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsModel_c.h, C++ API dsModel_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsSketchManager_c;
class dsModel_p;
class dsModel;
class dsCustomData_c;
class dsDictionary_c;
class dsViewTile_c;

class DSINTERFACE_EXPORT dsModel_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsModel)
public:
	DSRESULT IsSame(dsModel_c* Obj);

	DSRESULT IsActive(bool* Val);
	DSRESULT Activate();
	DSRESULT GetSketchManager(dsSketchManager_c** SkMngr);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyleTable(dsString*  Val);
	DSRESULT put_PrintStyleTable(const dsString&  NewVal);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT InsertViewTiles(dsViewTilesMode_e  Mode, dsViewTilesApplyTo_e  ApplyTo, dsObjectPtrArray * ViewTileArray);
	DSRESULT GetActiveViewTile(dsViewTile_c ** ViewTile);
	DSRESULT GetViewTiles(dsObjectPtrArray * ViewTileArray);
};
