//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathVector_c.h, C++ API dsMathVector_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMathVector_p;
class dsMathVector;
class dsMathTransform_c;
class dsMathPlane_c;
class dsMathPoint_c;
class DSINTERFACE_EXPORT dsMathVector_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathVector)
public:
	DSRESULT IsSame(dsMathVector_c* dsObj);

	DSRESULT GetCoordinates(double * X, double * Y, double * Z);
	DSRESULT SetCoordinates(double  X , double  Y , double  Z);
	DSRESULT Add(dsMathVector_c * Vector);
	DSRESULT Subtract(dsMathVector_c * Vector);
	DSRESULT ScaleVector(double  ScaleFactor);
	DSRESULT CrossProduct(dsMathVector_c * Vector, dsMathVector_c** ResultVector );
	DSRESULT DotProduct(dsMathVector_c * Vector, double * Result);
	DSRESULT GetLength(double * Length);
	DSRESULT Normalise( );
	DSRESULT TransformBy(dsMathTransform_c * Transform);
	DSRESULT AngleOnPlane(dsMathPlane_c * Plane, double * Angle);
	DSRESULT AngleTo(dsMathVector_c * Vector, double * Angle);
	DSRESULT IsCodirectionalTo(dsMathVector_c * Vector, double  Tolerance , bool * Result);
	DSRESULT IsParallelTo(dsMathVector_c * Vector, double  Tolerance , bool * Result);
	DSRESULT IsPerpendicularTo(dsMathVector_c * Vector, double  Tolerance , bool * Result);
	DSRESULT Negate( );
	DSRESULT ConvertToPoint(dsMathPoint_c ** MathPoint);
};
