//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathTransform_c.h, C++ API dsMathTransform_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMathTransform_p;
class dsMathTransform;
class DSINTERFACE_EXPORT dsMathTransform_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathTransform)
public:
	DSRESULT IsSame(dsMathTransform_c* dsObj);

	DSRESULT GetElementAt(long  Row, long  Column, double * Val);
	DSRESULT SetElementAt(long  Row, long  Column, double  NewVal);
	DSRESULT Inverse(dsMathTransform_c ** Transform);
	DSRESULT Multiply(dsMathTransform_c * Transform, dsMathTransform_c ** ResultTransform);
};
