//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathPoint_c.h, C++ API dsMathPoint_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMathPoint_p;
class dsMathPoint;
class dsMathTransform_c;
class dsMathVector_c;
class DSINTERFACE_EXPORT dsMathPoint_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathPoint)
public:
	DSRESULT IsSame(dsMathPoint_c* dsObj);

	DSRESULT GetPosition(double * X, double * Y, double * Z);
	DSRESULT SetPosition(double  X , double  Y , double  Z);
	DSRESULT Add(dsMathPoint_c * MathPoint);
	DSRESULT Subtract(dsMathPoint_c * MathPoint);
	DSRESULT ScalePoint(dsMathPoint_c * CenterPoint, double  ScaleFactor);
	DSRESULT TransformBy(dsMathTransform_c * Transform);
	DSRESULT ConvertToVector(dsMathVector_c ** Vector);
};
