//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathEllipArc_c.h, C++ API dsMathEllipArc_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsMathEllipArc_p;
class dsMathEllipArc;
class dsMathVector_c;
class dsMathPoint_c;
class dsMathPlane_c;
class dsMathLine_c;
class dsMathCircArc_c;
class dsMathTransform_c;

class DSINTERFACE_EXPORT dsMathEllipArc_c : public dsObject
{
    DECLARE_DSCPP_INTERFACE(dsMathEllipArc)
public:
    DSRESULT IsSame(dsMathEllipArc_c* dsObj);
    DSRESULT GetLength(double*  Length);
    DSRESULT GetNormal(dsMathVector_c ** Normal);
    DSRESULT GetMajorAxis(dsMathVector_c ** MajorAxis);
    DSRESULT GetMinorAxis(dsMathVector_c ** MajorAxis);
    DSRESULT GetStartPoint(dsMathPoint_c ** StartPoint);
    DSRESULT GetEndPoint(dsMathPoint_c ** EndPoint);
    DSRESULT GetPlane(dsMathPlane_c ** Plane);
    DSRESULT SetAxes(dsMathVector_c * MajorAxis, dsMathVector_c * MinorAxis);
    DSRESULT GetClosestPointTo(dsMathPoint_c * Point, dsMathPoint_c ** ClosestPoint);
    DSRESULT GetClosestPointToLinearObject(dsMathLine_c * LinearObject , dsMathPoint_c ** PointOnLinearObject , dsMathPoint_c ** ClosestPoint);
    DSRESULT GetClosestPointToCircArc(dsMathCircArc_c * CircArcObject , dsMathPoint_c ** PointOnCircArcObject , dsMathPoint_c ** ClosestPoint);
    DSRESULT GetClosestPointToEllipArc(dsMathEllipArc_c * EllipArcObject , dsMathPoint_c ** PointOnEllipArcObject , dsMathPoint_c ** ClosestPoint);
    DSRESULT GetClosestPointToPlane(dsMathPlane_c * Plane , dsMathPoint_c ** PointOnPlane , dsMathPoint_c ** ClosestPoint);
    DSRESULT IntersectWithLinearObject(dsMathLine_c * LinearObject, dsMathPoint_c ** IntersectionPoint1, dsMathPoint_c ** IntersectionPoint2, long*  NumIntersections);
    DSRESULT IntersectWithPlane(dsMathPlane_c * Plane , dsMathPoint_c ** IntersectionPoint1 , dsMathPoint_c ** IntersectionPoint2 , long*  NumIntersections);
    DSRESULT TransformBy(dsMathTransform_c * Transform);
    DSRESULT get_Center(dsMathPoint_c ** Val);
    DSRESULT put_Center(dsMathPoint_c * NewVal);
    DSRESULT get_StartAngle(double*  Val);
    DSRESULT put_StartAngle(double  NewVal);
    DSRESULT get_EndAngle(double*  Val);
    DSRESULT put_EndAngle(double  NewVal);
    DSRESULT get_MajorRadius(double*  Val);
    DSRESULT put_MajorRadius(double  NewVal);
    DSRESULT get_MinorRadius(double*  Val);
    DSRESULT put_MinorRadius(double  NewVal);
};
