//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLine_c.h, C++ API dsLine_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsDoubleArray.h"

class dsTransparency_c;
class dsLine_p;
class dsLine;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathLine_c;
class dsMathVector_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsLine_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLine)
public:
	DSRESULT IsSame(dsLine_c* val);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT GetFirstPoint(double* X, double* Y, double* Z);
	DSRESULT SetFirstPoint(double X, double Y, double Z);
	DSRESULT GetSecondPoint(double* X, double* Y, double* Z);
	DSRESULT SetSecondPoint(double X, double Y, double Z);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetLength(double * Length);
	DSRESULT GetClosestPointOn(double  GivenPointX, double  GivenPointY, double  GivenPointZ, bool  Extend, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ);
	DSRESULT GetEndParams(double * StartParameter, double * EndParameter);
	DSRESULT EvaluateAtParameter(double  Parameter, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ, double * Distance, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT EvaluateAtPoint(double  PointOnCurveX, double  PointOnCurveY, double  PointOnCurveZ, double * Parameter, double * Distance, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT EvaluateAtDistance(double  Distance, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ, double * Parameter, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT get_MathLine(dsMathLine_c ** Val);
	DSRESULT put_MathLine(dsMathLine_c * NewVal);
	DSRESULT get_Thickness(double * Val);
	DSRESULT put_Thickness(double  Val);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
