//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLineStyle_c.h, C++ API dsLineStyle_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsLineStyle_p;
class dsLineStyle;
class dsCustomData_c;
class dsColor_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsLineStyle_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLineStyle)
public:
	DSRESULT IsSame(dsLineStyle_c* dsObj);

	DSRESULT get_Name(dsString*  Val);
    DSRESULT get_Description(dsString * Val);
    DSRESULT put_Description(const dsString& NewVal);
    DSRESULT get_Handle(dsString*  Val);
    DSRESULT Activate( );
	DSRESULT Rename(const dsString&  Name, dsCreateObjectResult_e* Result);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
