//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLineStyleManager_c.h, C++ API dsLineStyleManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsLineStyleManager_p;
class dsLineStyleManager;
class dsLineStyle_c;
class DSINTERFACE_EXPORT dsLineStyleManager_c : public dsObject
{
    DECLARE_DSCPP_INTERFACE(dsLineStyleManager)
public:
    DSRESULT IsSame(dsLineStyleManager_c* dsObj);

    DSRESULT GetActiveLineStyle(dsLineStyle_c ** LineStyle);
    DSRESULT GetLineStyle(const dsString& Name, dsLineStyle_c ** LineStyle);
    DSRESULT GetLineStyles(dsObjectPtrArray * LineStyleArray);
    DSRESULT LoadLineStyle(const dsString& Name, const dsString& FileName, dsLineStyle_c** LineStyle, dsCreateObjectResult_e* Result);
    DSRESULT RemoveLineStyle(const dsString& Name, bool * Result);
};
