//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLeader_c.h, C++ API dsLeader_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsLeader_p;
class dsLeader;
class dsColor_c;
class dsDimensionStyle_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathVector_c;
class dsMathPoint_c;
class dsBlockInstance_c;
class dsTolerance_c;
class dsNote_c;
class dsDictionary_c;
class dsDimensionStyleUserData_c;
class dsTransparency_c;

class DSINTERFACE_EXPORT dsLeader_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLeader)
public:
	DSRESULT IsSame(dsLeader_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);

	DSRESULT get_Type(dsLeaderType_e* Val);
	DSRESULT put_Type(dsLeaderType_e NewVal);
	DSRESULT get_DimensionStyle(dsString*  Val);
	DSRESULT put_DimensionStyle(const dsString&  NewVal);
	DSRESULT GetDimensionStyleData(dsDimensionStyle_c ** DimensionStyle);
	DSRESULT GetVerticesCount(long * Val);
	DSRESULT GetVertexCoordinate(long  VertexIndex, double * X, double * Y, double * Z);
	DSRESULT GetAnnotationType(dsLeaderAnnotationType_e* AnnotationType);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetBlockAnnotation(const dsString&  BlockName, dsMathPoint_c * InsertPoint);
	DSRESULT GetBlockAnnotation(dsBlockInstance_c ** BlockInstance);
	DSRESULT SetToleranceAnnotation(const dsString&  ToleranceText, dsMathPoint_c * InsertPoint);
	DSRESULT GetToleranceAnnotation(dsTolerance_c ** Tolerance);
	DSRESULT GetNoteAnnotation(dsNote_c ** Text);
	DSRESULT SetNoteAnnotation(const dsString&  Text, dsMathPoint_c * InsertPoint);
	DSRESULT RemoveAnnotation( );
	DSRESULT SetVertexCoordinate(long  VertexIndex, double  X, double  Y, double  Z, bool * RetVal);
	DSRESULT AddVertex(double  X, double  Y, double  Z, bool * RetVal);
	DSRESULT RemoveLastVertex( );
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT GetDimensionStyleUserData(dsDimensionStyleUserData_c ** DimensionStyleUserData);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
